#version 330
#extension GL_EXT_gpu_shader4 : enable
//TheSkyWasSoPurpleMod01.fsh  by   Del
//https://www.shadertoy.com/view/4t2cWh
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define M_PI 3.141592

// tweaked version of this by 'bmodone' - https://www.shadertoy.com/view/4llcDH
// updated a bit since fabrice kindly commented :)

float radial(vec2 uv, float offset, float repeat)
{
    float a = mod((atan(uv.y, uv.x) + M_PI + (offset * 2.0 * M_PI)) * repeat / M_PI, 2.0);
    return min(a, 2.0 - a);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = ( gl_FragCoord.xy -.5 * iResolution.xy )/ iResolution.y;
       
    float _d = length(uv); 
 	float d = _d - 0.75;
    float off = _d;
    float a = radial(uv, sin(off*6.0-iTime*0.8)*0.161, 7.0) - 0.9;

    d = off - d*d+d+a*a+d;
    float m = _d+d+off;
    
    vec3 col = mix(vec3(0.1, 0.1, 0.19), vec3(0.18, 0.13, 0.31), m);
    col = (col-off*off)+d+a;
    
    vec3 backg = vec3(0.32,0.1,0.68);
    
    float m2 = col.r+col.g+col.b*0.25;
    col = mix(backg,col,m2);
    col *= _d-0.01;
    
	gl_FragColor = vec4(col,1.0);
}

