#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//JuliaRyuMod01.fsh   by  EvilRyu
//https://www.shadertoy.com/view/MdXXR4
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by evilryu - evilryu/2014
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
//
// Learned from iq

float ctime, stime;

vec3 render(vec2 p)
{
    vec2 cc=p*0.18; 
    vec2 z=cc;
    vec2 dz=vec2(1.0, 0.0); 
    float t0, t1,t2=0.0; 
    t0=t1=1e20; 
    float counter=0.; 
	
	// the main iteration for julia set
    for(int i=0;i<256;i++){ 
        if(dot(z,z)>256.0)continue; 
        dz=2.0*vec2(z.x*dz.x - z.y*dz.y, z.x*dz.y + z.y*dz.x);
        z=vec2(z.x*z.x - z.y*z.y, 2.0*z.x*z.y) + vec2(-0.74543+0.001*stime, 0.11301+0.001*ctime); 
        t0=min(t0, dot(dz,dz));
        t1=min(t1, dot(z-vec2(0.5,1.0),z-vec2(0.5,1.0))); 
        float d1=abs(z.y-sin(z.x*ctime))/abs(cos(z.x)); 
        float ff=step(d1,1.0); 
        counter+=ff; 
        t2+=ff*d1; 
    } 
    float d=sqrt(dot(z,z)/dot(dz,dz))*log(dot(z,z)); 

    //  coloring part
    float c=pow(clamp(d*50.0, 0.0, 1.0), 0.13); 
    float c0=pow(clamp(t0, 0.0, 1.0), 1.5); 
    float c1=pow(clamp(t1, 0.0, 1.0), 0.55); 
    float c2=pow(clamp(t2/counter, 0.0, 1.0), 0.9); 

    vec3 col0=0.5+0.5*sin(1.0+3.7*c+vec3(0.0,0.5,1.0)); 
    vec3 col1=0.5+0.5*sin(3.2+4.*c0+vec3(0.0,0.5,1.0)); 
    vec3 col2=0.5+0.5*sin(4.0+3.*c1+vec3(0.0,0.5,1.0)); 
    vec3 col3=0.5+0.5*sin(3.0+3.8*c2+vec3(0.0,0.5,1.0)); 
    vec3 col=sqrt(col1*col2*c*col3)*4.0; 
    
    return col;
}

vec2 getsubpixel(int id,vec2 fragCoord)
{
	vec2 aa=vec2(floor((float(id)+0.1)*0.5),mod(float(id),2.0));
	return vec2((2.0*fragCoord.xy+aa-iResolution.xy)/iResolution.y);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 q=fragCoord.xy/iResolution.xy; 
    stime = sin(iTime*0.2);
	ctime = cos(iTime*0.2);
     
   	vec3 col = vec3(0.0);
    for(int i=0;i<4;++i)
    {
        vec2 p = getsubpixel(i,fragCoord);
        p*=exp(sin(iTime*0.2)*0.1);
        col += render(p);
    }
    col/=4.0;

    col=col*0.6+0.4*col*col*(3.0-2.0*col);  // contrast
    col*=0.5+0.5*pow(16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y),0.25);  // vigneting
    fragColor=vec4(col.x,col.y,col.z,1.0); 
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

