#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// StructureFlyThoughMod01.fsh by  EvilRyu
//https://www.shadertoy.com/view/MlKSzR
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by evilryu
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

float smin(float a, float b, float k)
{
    float h = clamp(0.5+0.5*(b-a)/k, 0.0, 1.0);
    return mix(b, a, h) - k*h*(1.0-h);
}

float smax(float a, float b, float k)
{
    return smin(a, b, -k);
}

mat2 rot(float t)
{
    float c=cos(t);
    float s=sin(t);
    return mat2(c,-s,s,c);
}

vec3 path(float p)
{
   return vec3(sin(p*0.01)*cos(p*0.025)*20., sin(p*0.02)*cos(p*0.0125)*18.,0.);
}

vec4 texcube(sampler2D sam, vec3 p, vec3 n)
{
    vec4 p1=texture2D(sam, p.xy);
    vec4 p2=texture2D(sam, p.xz);
    vec4 p3=texture2D(sam, p.yz);
    return p1*abs(n.z)+p2*abs(n.y)+p3*abs(n.x);
}

float schwarz(vec3 p)
{
    return sin(p.x)*sin(p.y)*sin(p.z)+sin(p.x)*cos(p.y)*cos(p.z)+cos(p.x)*sin(p.y)*cos(p.z)+cos(p.x)*cos(p.y)*sin(p.z);
}

float map(vec3 p)
{
    p-=path(p.z);
    float d0=4.0-length(p.xy*vec2(0.2,0.4));  // Tunnel
    float d1=schwarz(p*0.08); // Schwarz
    float d2=dot(sin(p*0.6),cos(p.yzx*0.3)); // Gyroid
    float d=smax(d0,-d1,1.);
    d=smax(d,-d2,1.0);
    return d;
}

float bump(vec3 p, vec3 n)
{
    return dot(texcube(texture0, 0.1*p, n).xyz, vec3(0.299, 0.587, 0.114)); 
}

vec3 bump_mapping(vec3 p, vec3 n, float weight)
{
    vec2 e = vec2(2./iResolution.y, 0); 
    vec3 g=vec3(bump(p-e.xyy, n)-bump(p+e.xyy, n),
                bump(p-e.yxy, n)-bump(p+e.yxy, n),
                bump(p-e.yyx, n)-bump(p+e.yyx, n))/(e.x*2.);  
    g=(g-n*dot(g,n));
    return normalize(n+g*weight);
}

vec3 get_normal(vec3 p) {
	const vec2 e = vec2(0.002, 0);
	return normalize(vec3(map(p + e.xyy)-map(p - e.xyy), 
                          map(p + e.yxy)-map(p - e.yxy),	
                          map(p + e.yyx)-map(p - e.yyx)));
}


float intersect( in vec3 ro, in vec3 rd )
{
    float pixel_size = 1.0/(iResolution.x * 3.0);
    float t = 1.0;
    float res_t = 0.0;
    float res_d = 1000.0;
    float c;
    float max_error = 1000.0;
	float d = 1.0;
    float pd = 100.0;
    float os = 0.0;
    float step = 0.0;
    float error = 1000.0;
    
    for( int i=0; i<150; i++ )
    {
        if( error < pixel_size*0.5 || t > 200.0 )
        {
        }
        else{  // avoid broken shader on windows
        
            c = map(ro + rd*t);
            d = c;

            if(d > os)
            {
                os = 0.5 * d*d/pd;
                step = d + os;
                pd = d;
            }
            else
            {
                step =-os; os = 0.0; pd = 100.0; d = 1.0;
            }

            error = d / t;

            if(error < max_error) 
            {
                max_error = error;
                res_t = t;
            }
        
            t += step;
        }

    }
	if( t>200.0) t=-1.0;
    return t;
}


float get_ao(vec3 p, vec3 n)
{
    float r = 0.0, w = 1.0, d;
    for(float i=1.0; i<5.0+1.1; i++)
    {
        d = i/5.0;
        r += w*(d - map(p + n*d));
        w *= 0.5;
    }
    return 1.0-clamp(r,0.0,1.0);
}

float softshadow( in vec3 ro, in vec3 rd, float k )
{
    float res = 1.0;
    float t = 0.01;
	float h = 1.0;
    for( int i=0; i<24; i++ )
    {
        h = map(ro + rd*t);
        res = min( res, k*h/t );
        if( res<0.001 )break;
        t += clamp( h, 0.01, 2. );
    }
    return clamp(res,0.,1.0);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 q = fragCoord.xy / iResolution.xy;
    vec2 p = -1.0 + 2.0 * q;
    p.x *= iResolution.x/iResolution.y;

    if (abs(p.y)>.85) {
        fragColor = vec4(0.0, 0.0, 0.0, 1.0);
        return fragColor;
    }
    
    vec3 ro = vec3(0.0, 0., iTime*6.);
	vec3 look = ro + vec3(0.3*sin(iTime*0.4), 0., 0.5);

    ro+=path(ro.z);
    look+=path(look.z);
    vec3 forward=normalize(look-ro);
    vec3 right=normalize(cross(forward, vec3(0.0, 1.0, 0.0)));
    vec3 up=normalize(cross(right, forward));
    
    vec3 rd=normalize(p.x*right + p.y*up + 2.*forward);
    float t=intersect(ro,rd);
    vec3 col=0.1*vec3(1.1,0.8,0.5);
    if(t>-0.5)
    {
        vec3 pos=ro+t*rd;
        vec3 n=get_normal(pos);
        
        vec3 lp0=ro+vec3(0.0,50.0,0.0);
        lp0+=path(lp0.z);
        vec3 ld0=normalize(lp0-pos);
        
        vec3 material=texcube(texture0,pos*0.1,n).xyz;
        material=pow(material,vec3(1.1,1.8,1.8));
        
	    n=bump_mapping(pos, n, 2./(1.+t*0.5));
        
        float ao=get_ao(pos,n);
        
        float amb=0.5+0.5*n.y;
        float diff=max(0.0, dot(n,ld0));
        float bac=max(0.0,dot(n,-ld0));
        float spec=max(0.0, pow(clamp(dot(ld0, reflect(rd, n)), 0.0, 1.0), 16.0));
        float sha=softshadow( pos+0.2*ld0, ld0, 20.0 );
		vec3 lin=vec3(0.0);
        
        lin+=vec3(0.3)*amb*ao;
        lin+=vec3(7.,4.,3.)*diff*1.0*ao*sha;
        lin+=vec3(1.0,0.5,0.3)*bac*1.0*ao;
        lin+=vec3(spec*8.2)*sha;
        
        col=lin*0.2*material;
     }
    col=mix(col, 0.1*vec3(1.1,0.8,0.5), 1.0-exp(-0.0001*t*t) );
    col=pow(clamp(col,0.0,1.0),vec3(0.45));
    col=pow(col,vec3(1.3,1.,1.));
    col*=pow(16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y), 0.1);
    fragColor.xyz=col;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

