#version 330
#extension GL_EXT_gpu_shader4 : enable
//SpacefoldMod01.fsh by FreeFull
//https://www.shadertoy.com/view/lsGSzW
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float tau = 8.0 * atan(1.0);

mat2 rot(float angle) {
    return mat2(cos(angle), -sin(angle),
                sin(angle), cos(angle));
}

// https://iquilezles.org/articles/palettes
vec3 palette( in float t )
{
    vec3 a = vec3(0.5);
    vec3 b= vec3(0.5);
    vec3 c= vec3(1.0, 1.0, 0.5);
    vec3 d= vec3(0.8, 0.9, 0.3);
    return a + b*cos( 6.28318*(c*t+d) );
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;
    for(int i = 0; i < 32; i++) {
        uv = abs(uv);
        uv *= rot(iTime/30.0);
        uv += -vec2(0.5,0.5);
        uv *= 1.03;
    }
    uv = pow(abs(sin(uv)),vec2(0.3));
    vec3 col = palette(uv.x*uv.y*1.9);
	gl_FragColor = vec4(col,1.0);
}
