#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// RayMarchingMarch005Mod01.fsh by  Hirai_worthless
//https://www.shadertoy.com/view/3tlSRj
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.045
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 path(float z){
    float x = sin(z) + 2.0 * cos(z * 0.3) - 1.5 * sin(z * 0.12345);
    float y = cos(z) + 1.5 * sin(z * 0.3) + 2.0 * cos(z * 0.12345);
    return vec2(x,y);
}

float map(vec3 p){
	//p = fract(p/2.0) * 6.0 - 3.0;
    vec2 o = path(p.z) / 4.0;
	float tBase = max(-length(p.xy - o) + 1.0 
                      //* (1.0 + sin(p.z) * 0.5)
                      ,length(p.xy - o) - 1.2 
                      //* (1.0 + sin(p.z) * 0.5)
                     );
    float tdonut = max(-length(p.xy - o) + 0.5
                      ,length(p.xy - o) - 0.6 
                     );
    tdonut = max(tdonut,abs(fract(p.z) - 0.5));
    float tTube1 = length(p.xy - o + vec2(0.3,0.3)) - 0.025;
    float tTube2 = length(p.xy - o + vec2(0.5,0.2)) - 0.025;
    float tTube3 = length(p.xy - o + vec2(0.2,0.5)) - 0.025;    
    float tTube4 = length(p.xy - o + vec2(-0.3,-0.3)) - 0.025;
    float tTube5 = length(p.xy - o + vec2(-0.5,-0.2)) - 0.025;
    float tTube6 = length(p.xy - o + vec2(-0.2,-0.5)) - 0.025;
    float tTube = min(min(tTube1,tTube2),tTube3);
    tTube = min(min(tTube,tTube4),min(tTube5,tTube6));

    float bound = 2.0;
    float tSplit = (fract(p.z)-0.5);
    tSplit = min(tSplit, abs((p.x - o.x))-0.15);
    tSplit = min(tSplit, abs((p.y - o.y))-0.15);

    return min(min(max(tBase,-tSplit),tdonut),tTube);
}
const float EPS = 0.001;
vec3 getNormal(vec3 p) {
    return normalize(vec3(
        map(p + vec3(EPS, 0.0, 0.0)) - map(p + vec3(-EPS,  0.0,  0.0)),
        map(p + vec3(0.0, EPS, 0.0)) - map(p + vec3( 0.0, -EPS,  0.0)),
        map(p + vec3(0.0, 0.0, EPS)) - map(p + vec3( 0.0,  0.0, -EPS))
    ));
}

vec4 trace (vec3 o, vec3 r){
	float t = 0.0;
    vec3 p = vec3(0.0,0.0,0.0);
    
    for(int i = 0; i < 32; ++i){
        p = o + r * t;
        float d = map(p);
        t += d * 0.5;
    }
    return vec4(getNormal(p),t);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    float PI = 3.14159265;
    vec2 uv = fragCoord.xy /iResolution.xy;
	uv = uv * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;
    vec3 r = normalize(vec3(uv,0.5));

    float z = iTime * 4.0 ;
    
    r.xy *= mat2( sin(iTime),cos(iTime),
    				-cos(iTime),sin(iTime));
	vec2 a = path(z);
    vec3 o = vec3(a / 4.0,z);
    vec4 data = trace(o,r);
    float t = data.w;
    float fog = 1.0 / (1.0 + t * t * 0.2);
    vec3 fc = mix(vec3(0.5 - data.x,0.5 -data.y,0.5-data.z),vec3(0),1.0 - fog);
	//fc = vec3(fog);
    // Output to screen
    fragColor = vec4(fc,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

