#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//colorfulEmission001Mod01.fsh   by   Hirai_worthless  
//https://www.shadertoy.com/view/Wt2SWR
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float PI = 3.14159265;
//use for differential
const float EPS = 0.001;

//common function
mat2 genRot(float val){
	return mat2(cos(val), -sin(val),
               sin(val), cos(val));
}

float rand (float x){
    x = fract(sin(x*416.31434));
    x = fract(sin(x*234.41523));
    x = fract(sin(x*235.51424));
	return x;
}

float smin( float a, float b, float k )
{
    float res = exp2( -k*a ) + exp2( -k*b );
    return -log2( res )/k;
}

vec3 pmod(vec3 p,float c){
    float tmp = PI * 2. / c;
	float l = length(p.xy);
    float theta = atan(p.y/p.x);
    theta = mod(theta,PI * 2. / c);
    return vec3(l * cos(theta), l * sin(theta),p.z);
    
}


//Common SDF

float sphere(vec3 p,vec3 o,float r){
	return length(p - o) - r;
}

float cylinder(vec2 p,vec2 o,float r){
	return length(p - o) - r;
}

float cube(vec3 p,vec3 o,vec3 s){
    float x = abs(p.x - o.x) - s.x/2.;
    float y = abs(p.y - o.y) - s.y/2.;
    float z = abs(p.z - o.z) - s.z/2.;
    return max(x,max(y,z));
}

float line(vec3 p,vec3 q1,vec3 q2,float r){
	float t = clamp(
    	dot(q2 - p,q2 -q1)/dot(q2-q1,q2-q1),
    	0.,
        1.
    );
    vec3 q = t * q1 + (1. - t) * q2;
    return length(q - p) - r;
}


//Gathering SDF

float map(vec3 p){
    vec3 originalP = p;
    p.xy *= genRot(PI / 6.0 + p.z/8.);
    p = pmod(p,6.);
    p.xy *= genRot(-PI / 6.0);
    p.z = fract(p.z + 0.5) -0.5;
    
    float vol = 0.;
    for(float i = 0.0; i < 1.0; i++){
    	int tx = int(i*512.0);
        	float fft  = texelFetch( texture0, ivec2(tx,0), 0 ).x; 
        vol += fft;
    }
    
	float r = 1.25 + 0.15 * sin(originalP.z);
    p.x = fract((p.x / 3. + 0.5) -0.5) * 3.;
    float cubes = cube(p,vec3(2.0,0.,0.),vec3(0.5));
    float ringRad = 2.;
    float ring = max(cylinder(p.xy,vec2(0.),ringRad + 0.05),-cylinder(p.xy,vec2(0.),ringRad));
    ring = max(ring,abs(p.z) - 0.05);
    return min(cubes,ring);
}

//Getting Normal

vec3 getNormal(vec3 p) {
    return normalize(vec3(
        map(p + vec3(EPS, 0.0, 0.0)) - map(p + vec3(-EPS,  0.0,  0.0)),
        map(p + vec3(0.0, EPS, 0.0)) - map(p + vec3( 0.0, -EPS,  0.0)),
        map(p + vec3(0.0, 0.0, EPS)) - map(p + vec3( 0.0,  0.0, -EPS))
    ));
}

//Setting CameraPos
vec3 Camera(float t){
    vec3 c = vec3(.0,.0,-2.0 + iTime * 4.);
	return c;
}

//Setting Ray
vec3 Ray(vec2 uv, float z){
	vec3 ray = normalize(vec3(uv,z));
    ray.xz *= genRot(PI / 8.);
    ray.yz *= genRot(PI / 16.);
    ray.xy *= genRot(iTime / 4.);
    
    return ray;
}

//Tracing Ray

vec4 trace (vec3 o, vec3 r){
	float t = 0.0;
    vec3 p = vec3(0.0,0.0,0.0);
    
    for(int i = 0; i < 128; ++i){
        p = o + r * t;
        float d = map(p);
        t += d * 0.75;
    }
    return vec4(getNormal(p),t);
}

//Making color
vec3 getColor(vec3 o,vec3 r,vec4 data){
    float t = data.w;
    float fog = 1.0 / (1.0 + t * t * 0.005);
    float a = dot(data.xyz,r);
    vec3 p = o + r * t;
    float at = atan(r.y/r.x)/PI + 0.5;
    vec3 ccol = vec3(sin(at * PI), 1. - sin(at * PI),sin(p.z) + 0.1);
    vec3 fc = vec3(0.05);
    fc = mix(fc,vec3(1.),1. + a*1.);
	fc += fract(p.z / 2. + length(p.xy)/2. + iTime * 2.) < 0.5 ? ccol * 1.5 : vec3(0.);
    
    fc = mix(vec3(0.05),fc,fog);
    //fc = vec3(fog);
    return fc;
}

//Drawing

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    //set canvas
    vec2 uv = fragCoord.xy /iResolution.xy;
	uv = uv * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;
    
    //set camera and ray
    vec3 r = Ray(uv,1.2);
    vec3 o = Camera(iTime);
    
    //trace ray
    vec4 data = trace(o,r);
    vec3 fc = getColor(o,r,data) ;
	//fc = vec3(fog);
    // Output to screen
    fragColor = vec4(fc,1.0);
      

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

