#version 330
#extension GL_EXT_gpu_shader4 : enable
//voronoioo2Mod01.fsh  by akin
//https://www.shadertoy.com/view/WtcBRN
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float rand(vec2 co)
{
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

float len(vec2 a , vec2 b)
{
    vec2 c = abs(a-b);
    return sqrt(pow(c.x, 2.0) + pow(c.y, 2.0));
}

vec2 getNormal(float v, float power)
{
    return vec2(dFdx(v), dFdy(v)) * power;
}

// https://iquilezles.org/articles/smoothvoronoi
float smoothVoronoi( in vec2 x )
{
    ivec2 p = ivec2( x );
    vec2  f = fract( x );

    float res = 0.0;
    for( int j=-1; j<=1; j++ )
    for( int i=-1; i<=1; i++ )
    {
        ivec2 b = ivec2( i, j );
        vec2  r = vec2( b ) - f + rand( vec2(p + b) );
        float d = dot( r, r );

        res += 1.0/pow( d, 8.0 );
    }
    return pow( 1.0/res, 1.0/16.0 );
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy - 0.5;
    vec2 mid = vec2(0.0, 0.0);
    
    float cSpeed = 4.0;
    vec2 uvb = uv + vec2(sin(iTime * cSpeed), cos(iTime * cSpeed)) * 0.1;
    float val = smoothVoronoi(uvb * 4.0 + 500.0) * 2.0;
    vec2 distort = getNormal(val, 10.0);
    
    uv = uv + (distort * sin(iTime));
    
    vec3 fufu;
    fufu.r = smoothVoronoi(uv * 10.0 + 1000.0);
    fufu.g = smoothVoronoi(uv * 11.0 + 1000.0);
    fufu.b = smoothVoronoi(uv * 12.0 + 1000.0);
    
    gl_FragColor = vec4(fufu, 1.0);
}