#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//bubbles_DMod01.fsh   by   auurora
//https://www.shadertoy.com/view/......
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

struct bubble
{
    vec2 pos;
    float radius;
};

const vec4 bubble_blue = vec4(0.017, 0.673, 0.743, 1.);
const vec4 bubble_pale = vec4(0.57, 0.673, 0.743, 1.);
const vec4 bubble_indigo = vec4(0.27, 0.073, 0.543, 1.);

vec4 render_bubble(in vec2 coord, in bubble object)
{
    float zw = distance(coord, object.pos) / (object.radius*2.);
    float alpha = 1.-smoothstep(0.49, 0.59, zw);

    vec4 color = bubble_blue;
    
    color = mix(color, bubble_indigo, (5.*sqrt(distance(coord, object.pos)))/object.radius);
    color = 
        mix(
            color, 
            bubble_pale, 
            max(
                (coord.y - object.pos.y) / object.radius,
                (object.pos.y - coord.y) / object.radius
            )
        );
    vec2 lw = (coord - object.pos) / object.radius;
        
    vec4 wlc = vec4(0.5 + 0.5*cos(iTime+(coord/iResolution.yx).xyx/0.1+vec3(atan(lw.y,lw.x),2,4)), 1.);
    color = mix(color, wlc, (5.*sqrt(distance(coord, object.pos)))/object.radius);
        
    float ralpha = (
                alpha * 
                max(
                    smoothstep(0.,1.,zw), 
                    (coord.y - object.pos.y) / object.radius
                )
            );
            
    return vec4(color.rgb+(ralpha/2.), ralpha);
    
}

float fluctuation(float r, float r2)
{
    return sin(10.f*r + iTime/(2.f+(r*5.f))) * (30.f + (60.f*r2));
}



float prand(in vec2 n)
{
    return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);
}

float prand(in float modifier)
{
    return prand(vec2(modifier, 1.));
}

float noise(vec2 p){
	vec2 ip = floor(p);
	vec2 u = fract(p);
	u = u*u*(3.0-2.0*u);
	
	float res = mix(
		mix(prand(ip),prand(ip+vec2(1.0,0.0)),u.x),
		mix(prand(ip+vec2(0.0,1.0)),prand(ip+vec2(1.0,1.0)),u.x),u.y);
	return res*res;
}

const vec4 water_color = vec4(0.12, 0.21, 0.613, 1.);
const vec4 water_color_2 = vec4(0.12, 0.41, 0.713, 1.);

mat2 rmat(float w){
    return mat2(vec2(cos(w), -sin(w)), vec2(sin(w), cos(w)));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = fragCoord/iResolution.xy;
    
    vec2 c = (uv-(vec2(0.5, 1.)));
    float m = atan(c.y,c.x);
    float rayx = sin(m)*cos(m);
    
    fragColor = mix(water_color, water_color_2, smoothstep(0.,1.,noise(vec2(rayx*20. + iTime, 1.))));
    
    fragColor = mix(fragColor, vec4(0.), 1.-uv.y);
    for (int i = 1; i < 25; ++i)
    {
        float bw = float(i);
        float r1 = prand(bw);
        float r2 = prand(bw + .21);
        float r3 = prand(bw + .69);
        float r4 = prand(bw + .82) + 0.1;
        bubble w = 
            bubble(
                vec2(
                    r1 * iResolution.x + fluctuation(r1, r2), 
                    mod(((10.+(50.*r4))*iTime*(0.3+prand(bw+.11)*1.9)) - (r3*iResolution.y), iResolution.y + 100.) - 50.
                ),
                40.+(prand(bw+.91)*10.)*(iResolution.x/500.)
            );
            
        vec4 c = render_bubble(fragCoord, w);
        fragColor = vec4(mix(fragColor.rgb, c.rgb, c.a), 1.);
    }
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

