#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// HearthbeatMod01.fsh   by   ceceppa 
//https://www.shadertoy.com/view/wlGXWt
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed   //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float SCALE = 2.;
const float LINES_WIDTH = 0.05;
const float DOT_SPEED_LIMITER = 5.;
const float EGC_SCALE = 1.;
const int MAX_TRAIL_ITEMS = 500;

const vec3 GRID_COLOR = vec3(.01, .07, .06);
const vec3 DOT_COLOR = vec3(1., 1., 1.);
const vec3 BLURRED_COLOR = vec3(.15, .68, .83);
const vec3 RING_COLOR = vec3(.10, .24, .25);

float remap01(float t, float a, float b) {
    return (t - a) / (b - a);
}

float Circle(vec2 uv, vec2 position, float radius, float blur) {
    float distance = length(uv - position);

    return smoothstep(radius, radius - blur, distance);
}

float GridLines(float t, float lines) {
    return step(fract(t * lines), LINES_WIDTH);
}

vec3 Ring(vec2 uv, vec2 position) {
    float ring = Circle(uv, position, .08, .01);
	ring -= Circle(uv, position, .065, .01);
    
    return RING_COLOR * ring;
}


float spike(float x, float d, float w, float raiseBy) {
    float f1 = pow(abs(x + (d * SCALE)), raiseBy);

    return exp(-f1 / w);
}

float generateEGC(float x) {
    x -= .5 * SCALE;

    float a = 0.4 * SCALE;
	float d = .3;
	float w = 0.001;
    
    float f1 = a * spike(x, d, w, 2.);
    float f2 = a * spike(x, d - 0.1, 2. * w, 2.);
    float f3 = a * 0.7 * spike(x, d - 0.3, 0.002, 2.);
    float f3a = 0.15 * spike(x, d - 0.37, 0.0001, 4.);
    float f4 = 0.25 * spike(x, d - 0.5, 0.005, 2.);
    float f5 = 0.1 * spike(x, d - 0.75, 0.0001, 4.);

    float f6 = a * spike(x, d - 1., 0.002, 2.);
    float f7 = 0.5 * spike(x, d - 1.1, w, 2.);

    float f8 = 0.1 * spike(x, d - 1.3, 0.0001, 4.);
    float f9 = 0.1 * spike(x, d - 1.45, 0.0001, 4.);

    return f1 - f2 + f3 + f3a - f4 + f5 + f6 - f7 - f8 + f9;
}

float getDotXPosition() {
    // Animate the dot position from left --> right
    float dotX = fract(iTime / DOT_SPEED_LIMITER);
	dotX *= 2. * SCALE;

    return dotX;
}

vec3 MovingDot(vec2 uv, vec2 dotPosition) {
    float movingDot = Circle(uv, dotPosition, .015, .01);
    float smallBlurredDot = Circle(uv, dotPosition, .06, .1);
	float bigBlurredDot = Circle(uv, dotPosition, .3, .6);

    vec3 color = DOT_COLOR * movingDot;
    color += BLURRED_COLOR * smallBlurredDot;
    color += BLURRED_COLOR * bigBlurredDot;
    color += Ring(uv, dotPosition);

    return color;

}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord/iResolution.xy;

    // Scale the view
    uv *= SCALE;

    uv.y -= .5 * SCALE; // Center the Y axis
    uv.x *= iResolution.x / iResolution.y; // Keeps the aspect ratio

    float grid = GridLines(uv.x, 6.) + GridLines(uv.y, 6.);
    vec3 color = GRID_COLOR * grid;

    float dotX = getDotXPosition();
    vec2 dotPosition = vec2(dotX, generateEGC(dotX));

	color += MovingDot(uv, dotPosition);

    for(int i = 1; i < MAX_TRAIL_ITEMS; i++) {
        float delayedX = dotX - (float(i) * 0.002);
		vec2 trailPosition = vec2(delayedX, generateEGC(delayedX));

        float trail = Circle(uv, trailPosition, 0.028, 0.1);
        float trailBlur = Circle(uv, trailPosition, 0.06, 0.5);

        float q = 1. - remap01(float(i), 1., float(MAX_TRAIL_ITEMS));

        color += (DOT_COLOR * q) * trail;
        color += trailBlur * (BLURRED_COLOR * q);
    }

    fragColor = vec4(color,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

