#version 330
#extension GL_EXT_gpu_shader4 : enable
//CanalsMod01.fsh  by  dila
//https://www.shadertoy.com/view/lsKyzW
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float mapw = 0.0;
float mapc = 0.0;
float mapl = 0.0;
float mapv = 0.0;

mat2 rot(float x) {
    return mat2(cos(x), sin(x), -sin(x), cos(x));
}

float bump(vec3 p) {
    vec2 uv = (p.xz - vec2(0.0, iTime * 1.2)) * 0.05;
    uv.y -= cos(p.x * 3.141592 * 0.5) * 0.02;
    float tex = dot(texture(iChannel1, uv).xyz, vec3(1.0)) / 3.0;
    return (tex * 2.0 - 1.0) * 0.005;
}

vec2 wiremap(vec3 p) {
    return p.xy * rot(0.6 + sin(p.z / 3.141592 * 4.0) * 0.125);
}

float vent(vec3 p) {
	return max(abs(abs(p.x) - 2.0) - 0.02, abs((fract(p.y * 8.0 - 0.3) - 0.5) / 8.0) - 0.02);
}

float map(vec3 p) {
    p.x += sin(p.z) * 0.5;
	float t = 2.0 - length(p.xy);
    float f = p.y + bump(p);
    float e = max(abs(abs(p.x) - 20.0) - 18.7, abs(p.y) - 0.3);
    float c = length(vec2(p.y - 0.5, (fract(p.z / 3.0) - 0.5) * 3.0)) - 0.75;
    vec2 k = wiremap(p);
    float s = length(vec2(k.y - 1.9, abs(k.x) - 0.025)) - 0.015;
    float l = length(vec3(k.y - 1.85, k.x, (fract(p.z / 4.0) - 0.5) * 4.0)) - 0.05;
    float v = min(vent(p), vent(p.xzy));
    t = max(t, -c);
    t = min(t, e);
    mapv = max(sign(t - v), 0.0);
    t = min(t, v);
    mapw = max(t - f, 0.0);
    t = min(t, f);
    mapc = max(sign(t - s), 0.0);
    t = min(t, s);
    mapl = max(sign(t - l), 0.0);
    return min(t, l);
}

vec2 mapuv(vec3 p, vec3 sn) {
    p.x += sin(p.z) * 0.5;
	float t = 2.0 - length(p.xy);
    float f = p.y + bump(p);
    float e = max(abs(abs(p.x) - 20.0) - 18.7, abs(p.y) - 0.3);
    float c = length(vec2(p.y - 0.5, (fract(p.z / 3.0) - 0.5) * 3.0)) - 0.75;
    float v = min(vent(p), vent(p.xzy));
    t = max(t, -c);
    vec2 bt = mix(p.yz, p.xz, max(sign(sn.y), 0.0));
    t = min(t, f);
    bt = mix(p.xz, bt, max(sign(t - e), 0.0));
    t = min(min(t, f), e);
    bt = mix(p.yz, bt, max(sign(v - t), 0.0));
    return bt;
}

vec3 normal(vec3 p)
{
	vec3 o = vec3(0.01, 0.0, 0.0);
    return normalize(vec3(map(p+o.xyy) - map(p-o.xyy),
                          map(p+o.yxy) - map(p-o.yxy),
                          map(p+o.yyx) - map(p-o.yyx)));
}
        
float trace(vec3 o, vec3 r) {
    float t = 0.0;
    for (int i = 0; i < 32; ++i) {
        t += map(o + r * t);
    }
    return t;
}

float fog(vec3 w, vec3 sn, float f) {
    w.x += sin(w.z) * 0.5;
    float h = max(2.3 - abs(w.x), 0.0);
    return f * h;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;

    vec3 r = normalize(vec3(uv, 1.2));
    vec3 o = vec3(0.0, 1.0, iTime * 0.5);
    
    o.x -= sin(o.z) * 0.5;
    o.y += sin(o.z * 4.0) * 0.02;
    float ms = (iMouse.x / iResolution.x * 2.0 - 1.0) * sign(iMouse.z);
    r.xz *= rot(sin(o.z) * 0.5 + ms);
    r.xy *= rot(-sin(o.z) * 0.1);
    
    vec3 lcol = vec3(2.0, 2.0, 2.0);
    
    float t = trace(o, r);
    float tw = mapw;
    float tc = mapc;
    float tl = mapl;
    float tv = mapv;
    vec3 w = o + r * t;
    vec3 sn = normal(w);
    vec3 tex = texture(iChannel0, mapuv(w, sn)).xyz;
    tex *= tex;
    tex = mix(tex, tex.xxx * 0.125, tv);
    tex = mix(tex, vec3(0.7, 0.7, 0.0), tc);
    tex *= max(dot(-r, sn), 0.0);
    tex = mix(tex, lcol, tl);
    float aoc = map(w + sn * 1.1);
    tex *= 0.5 + aoc;
    float f = 1.0 / (1.0 + t * t * 0.1);
    
	vec3 rr = reflect(r, sn);
    float rt = trace(w + rr * 0.01, rr);
    float rtw = mapw;
    float rtc = mapc;
    float rtl = mapl;
    float rtv = mapv;
    vec3 rw = w + rr * rt;
    vec3 rsn = normal(rw);
    vec3 rtex = texture(iChannel0, mapuv(rw, rsn)).xyz;
    rtex *= rtex;
    rtex = mix(rtex, rtex.xxx * 0.125, rtv);
    rtex = mix(rtex, vec3(0.7, 0.7, 0.0), rtc);
    rtex = mix(vec3(0.0, 0.0, 0.0), rtex, 1.0-abs(dot(r,sn)));
    rtex *= max(dot(-rr, rsn), 0.0);
    rtex = mix(rtex, lcol, rtl);
    float raoc = map(rw + rsn * 1.1);
    rtex *= 0.5 + raoc;
    float rf = 1.0 / (1.0 + rt * rt * 0.1);

	tex = mix(vec3(0.0), tex, fog(w, sn, f));
	rtex = mix(vec3(0.0), rtex, fog(rw, rsn, rf * f));
    
    float twf = 1.0 / (1.0 + tw * 20.0);
    vec3 wtex = texture(iChannel1, mapuv(w, sn)).xyz;
    wtex *= wtex;
    vec3 rfc = mix(rtex, wtex, pow(abs(dot(-r, sn)), 3.0));
    vec3 fc = mix(rfc * vec3(0.2, 0.2, 0.1) * 8.0, tex, twf);
    
    float lt = 0.0;
    for (int i = 0; i < 16; ++i) {
        vec3 p = o + r * lt;
        p.x += sin(p.z) * 0.5;
        p.xy = wiremap(p);
        p.z = (fract(p.z / 4.0) - 0.5) * 4.0;
        float ld = length(vec3(p.x, p.y - 1.85, p.z)) - 0.0125;
        lt += ld * 0.4;
    }
    fc = mix(fc, lcol, 1.0 / (1.0 + lt * lt * 0.5));
    
    gl_FragColor = vec4(sqrt(fc), 1.0);
}

