#version 330
#extension GL_EXT_gpu_shader4 : enable
//DockingMod01.fsh  by   dila 

//https://www.shadertoy.com/view/4lSXDw
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 map(vec3 p)
{
    float g = 4.0;
	vec3 q = (fract(p/g) * 2.0 - 1.0) * g;
    float m = 0.0;
    float md = 1000.0;
    const int ni = 3;
    for (int i = 0; i < ni; ++i) {
       	float f = float(i+1) / float(ni);
        vec3 s = 0.5 - abs(normalize(q));
        q = sign(q) * s;
        float d = length(q) - 0.25;
        if (d < md) {
            md = d;
            m = f;
        }
    }
    float tr = mix(1.0, 4.0, 0.5+0.5*sin(p.z*4.0));
    float cv = pow(length(p.xy), 0.5) - tr;
    md = max(md, -cv);
    return vec2(md, m);
}

vec3 normal(vec3 p)
{
	vec3 o = vec3(0.01, 0.0, 0.0);
    return normalize(vec3(map(p+o.xyy).x - map(p-o.xyy).x,
                          map(p+o.yxy).x - map(p-o.yxy).x,
                          map(p+o.yyx).x - map(p-o.yyx).x));
}

float trace(vec3 o, vec3 r)
{
    float t = 0.0;
    for (int i = 0; i < 128; ++i) {
        vec3 p = o + r * t;
        float d = map(p).x;
        t += d * 0.1;
    }
    return t;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;
    
    vec3 r = normalize(vec3(uv, 1.0));
    vec3 o = vec3(0.0, 0.0, iTime);
    
    float t = trace(o, r);
    vec3 w = o + r * t;
    vec2 fd = map(w);
   	vec3 sn = normal(w);
    
    float prod = max(dot(r, -sn), 0.0);
    float fog = prod * 1.0 / (1.0 + t * t * 0.01 + fd.x * 100.0);
    
    vec3 sc = vec3(0.25, 0.5, 1.0);
    vec3 ec = vec3(1.0, 1.0, 1.0);
    vec3 fc = mix(sc, ec, fd.y);
    
    fc *= fog;
    
	gl_FragColor = vec4(sqrt(fc),1.0);
}