#version 330
#extension GL_EXT_gpu_shader4 : enable
//FlamingThingMod01.fsh  by dila
//https://www.shadertoy.com/view/lldSRM
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

mat2 rot(float x)
{
    return mat2(cos(x), sin(x), -sin(x), cos(x));
}

float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

vec3 mpos = vec3(0.0);
float mid = 0.0;

float map(vec3 p)
{
    vec3 q = p;
    
    q.y += sin(q.z * 0.125) * 3.0;
    
    q.x -= (sin(q.z * 0.25) * 0.5 + 0.5) * 3.0;
    
    q.xy *= rot(iTime);
    
    float u = 0.125;
    q.z = (fract(q.z / u) - 0.5) * u;
    
    vec3 s = vec3(1.0, 0.125, 0.25);
    
    const int n = 4;
    for (int i = 0; i < n; ++i) {
        q.y = abs(q.y) - 0.5;
        q.xy *= rot(3.14159 * 0.125);
        q = abs(q) - 0.125;
        q.xy *= rot(p.z * 0.5);
    }
    
    mpos = p;
    mid = 0.0;
    float d = 8.0 - p.x;
    
    float k = sdBox(q, s);
    
    if (k < d) {
    	d = k;
        mpos = q * 10.0;
        mid = 1.0;
    }
    
    return d;
}

vec3 normal(vec3 p)
{
	vec3 o = vec3(0.01, 0.0, 0.0);
    return normalize(vec3(map(p+o.xyy) - map(p-o.xyy),
                          map(p+o.yxy) - map(p-o.yxy),
                          map(p+o.yyx) - map(p-o.yyx)));
}

float trace(vec3 o, vec3 r)
{
	float t = 0.0;
    for (int i = 0; i < 40; ++i) {
		t += map(o + r * t) * 0.7;
    }
    return t;
}

vec3 texturef(sampler2D channel, vec3 p)
{
    vec3 ta = texture2D(channel, p.xy).xyz;
    vec3 tb = texture2D(channel, p.xz).xyz;
    vec3 tc = texture2D(channel, p.zy).xyz;
    return (ta * ta + tb * tb + tc * tc) / 3.0;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;
    
    vec3 o = vec3(-9.0, 0.0, iTime * 10.0);
    vec3 r = normalize(vec3(uv, 1.0));
    
    r.xy *= rot(sin(iTime * 0.25) * 0.5);
    r.xz *= rot(3.14159 * 0.5);
    
    float t = trace(o, r);
    vec3 w = o + r * t;
    vec3 sn = normal(w);
    float fd = map(w);
    float ao = map(w + sn * 1.2);
    
    vec3 lcol1 = vec3(1.0, 0.5, 0.25) * 2.0;
    vec3 lcol2 = vec3(0.5, 1.0, 1.0);
    
    vec3 tex = vec3(0.0);
    if (mid == 0.0) {
    	tex = texture2D(iChannel0, mpos.yz * 0.03).xyz;
        tex *= tex;
    } else {
        tex = texturef(iChannel1, mpos * 0.05);
        tex *= vec3(1.0, 0.5, 0.25);
    }

    vec3 lpos = o += vec3(-1.0, 8.0, -2.0);
    vec3 ldel = w - lpos;
    float ldist = length(ldel);
    ldel /= ldist;
    float lt = trace(lpos + sn * 0.5, ldel);
    float lm = max(dot(ldel, -sn), 0.0);
    lm /= (1.0 + ldist * ldist * 0.001);
    if (lt < ldist) {
        lm *= 0.25;
    }
    
    if (mid == 1.0) {
        vec3 ref = reflect(ldel, sn);
    	float spec = max(dot(r, -ref), 0.0);
    	spec = pow(spec, 2.0);
        lcol1 *= 1.0 + spec;
    	lcol2 *= 1.0 + spec;
    }
    
    vec3 lit = vec3(lm) * lcol2 + lcol1 * (sn.y * 0.5 + 0.5);
    
    float edge = 1.0 - 1.0 / (1.0 + fd * 100.0);
    
    vec3 fc = mix(lit * tex, lcol1, edge) * ao;
    
	gl_FragColor = vec4(sqrt(fc), 1.0);
}