#version 330
#extension GL_EXT_gpu_shader4 : enable
// RubiksCubeMod01.fsh  by  dila
//https://www.shadertoy.com/view/MlS3DG
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159 //*0.628318//*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define STEP_COUNT 8

const float pi = 3.14159;

mat3 xrot(float t)
{
    return mat3(1.0, 0.0, 0.0,
                0.0, cos(t), -sin(t),
                0.0, sin(t), cos(t));
}

mat3 yrot(float t)
{
    return mat3(cos(t), 0.0, -sin(t),
                0.0, 1.0, 0.0,
                sin(t), 0.0, cos(t));
}

mat3 zrot(float t)
{
    return mat3(cos(t), -sin(t), 0.0,
                sin(t), cos(t), 0.0,
                0.0, 0.0, 1.0);
}

float mask(float a, float b)
{
    return max(sign(a-b), 0.0);
}

float interp(float a, float b)
{
    float m = mask(a, b);
    return m * pi * 0.5 * clamp(a-b, 0.0, 1.0);
}

mat3 scramble(vec3 p)
{
    mat3 r = mat3(1.0);
    float pt = (0.5+0.5*sin(iTime*0.25)) * 6.0;

    if (p.x == -1.0) {
        r = r * xrot(interp(pt, 0.0));
    }
    
    vec3 q = p * r;
    if (floor(q.y+0.5) == -1.0) {
        r = r * yrot(interp(pt, 1.0));
    }
    
    q = p * r;
    if (floor(q.z+0.5) == -1.0) {
        r = r * zrot(interp(pt, 2.0));
    }
    
    q = p * r;
    if (floor(q.x+0.5) == 1.0) {
        r = r * xrot(interp(pt, 3.0));
    }
    
    q = p * r;
    if (floor(q.y+0.5) == 1.0) {
        r = r * yrot(interp(pt, 4.0));
    }
    
    q = p * r;
    if (floor(q.z+0.5) == 1.0) {
        r = r * zrot(interp(pt, 5.0));
    }
    
    return r;
}

float cube(vec3 p)
{
  vec3 d = abs(p) - vec3(1.0 / 32.0);
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}

vec3 normal(vec3 p)
{
    vec3 o = vec3(0.01, 0.0, 0.0);
    return normalize(vec3(cube(p+o.xyy) - cube(p-o.xyy),
                          cube(p+o.yxy) - cube(p-o.yxy),
                          cube(p+o.yyx) - cube(p-o.yyx)));
}

vec3 colour(vec3 p)
{
	vec3 sn = normal(p);
    vec3 ln = 0.5 + 0.5 * sn;
    vec3 asn = abs(sn);
    float mc = max(asn.x, max(asn.y, asn.z));
    
    if (mc == asn.x) {
        return mix(vec3(1.0, 1.0, 1.0), vec3(1.0, 1.0, 0.0), ln.x);
    }
    
    if (mc == asn.y) {
        return mix(vec3(0.0, 1.0, 0.0), vec3(0.0, 0.0, 1.0), ln.y);
    }
    
    if (mc == asn.z) {
        return mix(vec3(1.0, 0.0, 0.0), vec3(1.0, 0.5, 0.0), ln.z);
    }
    
    return vec3(0.0);
}

vec4 map(vec3 p)
{
    p *= xrot(iTime) * zrot(iTime*2.0);
    
    float d = 1000.0;
    vec3 f = vec3(0.0);
    for (int i = -1; i <= 1; ++i) {
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                vec3 v = vec3(float(i),float(j),float(k));
                vec3 o = scramble(v) * p + v;
                vec3 c = clamp(o, -0.45, 0.45);
                float m = length(c - o);
                if (m < d) {
                    d = m;
                    f = o;
                }
            }
        }
    }
    return vec4(d, colour(f));
}

float trace(vec3 o, vec3 r)
{
 	float t = 0.0;
    for (int i = 0; i < STEP_COUNT; ++i) {
        vec3 p = o + r * t;
        float d = map(p).x;
        t += d;
    }
    return t;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;
    
    vec3 r = normalize(vec3(uv, 1.0));
    
    vec3 o = vec3(0.0, 0.0, -4.0);
    
    float t = trace(o, r);
    vec3 w = o + r * t;
    vec4 fd = map(w);
    
    float bl = 1.0 / (1.0 + t * t * 0.01 + fd.x * 100.0);
    
    vec3 bk = mix(vec3(0.8,0.8,1.0), vec3(0.5,0.5,0.5), 0.5+0.5*uv.y);
    
    vec3 fc = mix(fd.yzw, bk, 1.0-bl);
    
	gl_FragColor = vec4(fc,1.0);
}