#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//ZoomTestMod01.fsh   by dila   
//https://www.shadertoy.com/view/lt23WV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.0885  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float pi = 3.14159;

mat3 xrot(float t)
{
    return mat3(1.0, 0.0, 0.0,
                0.0, cos(t), -sin(t),
                0.0, sin(t), cos(t));
}

mat3 yrot(float t)
{
    return mat3(cos(t), 0.0, -sin(t),
                0.0, 1.0, 0.0,
                sin(t), 0.0, cos(t));
}

mat3 zrot(float t)
{
    return mat3(cos(t), -sin(t), 0.0,
                sin(t), cos(t), 0.0,
                0.0, 0.0, 1.0);
}

vec3 paxis(vec3 p)
{
    vec3 a=abs(p),r = vec3(1.0,0.0,0.0);
    if(a.z>=max(a.x,a.y))r=r.yzx;
    else if(a.y>=a.x)r=r.zxy;
    return r*sign(p);
}

vec3 ddt(vec3 s)
{
	vec3 r;
    vec3 as = abs(s);
	r.x = s.x * min((1.0 - as.y),(1.0 - as.z));
    r.y = s.y * min((1.0 - as.x),(1.0 - as.z));
    r.z = s.z * min((1.0 - as.x),(1.0 - as.y));
    return r;
}

float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}

float sdBoxInfinite( vec3 p, vec3 b )
{
  vec2 d = abs(p.xy) - b.xy;
  return min(max(d.x,d.y),0.0) +
         length(max(d,0.0));
}

vec2 map(vec3 p)
{
    float k = 12.0;

    p.z = (fract(p.z/k) * 2.0 - 1.0) * k * 0.5;
    
    vec3 op = p;
    
    float d = 1000.0;
    
    vec3 ip = p;
    
    float bs = 1.0;
    float r = 0.0;
    
    const int it = 6;
    for (int i = 0; i < it; ++i) {

        float nbs = bs;
        bs = nbs * 0.5;

        vec3 pn = paxis(ip);
        
        vec3 apn = abs(pn);
        
        pn += sign(pn) * max(apn.x,max(apn.y,apn.z));
        
        vec3 disp = ddt(normalize(ip));
        
        pn += disp * 3.0;

		ip -= pn * nbs;

        float fd = length(ip) - nbs;
        
        if (fd < d) {
            d = fd;
            r = float(i);
        }
        
        float nm = float(i) / float(it-1);
        float rd = mix(1.5, 0.5, nm);
        //d = max(d, rd-length(op.xy));
        d = max(d, -sdBoxInfinite(op,vec3(rd)));
	}
    
    return vec2(d,r);
}

vec3 normal(vec3 p)
{
	vec3 o = vec3(0.01, 0.0, 0.0);
    return normalize(vec3(map(p+o.xyy).x - map(p-o.xyy).x,
                          map(p+o.yxy).x - map(p-o.yxy).x,
                          map(p+o.yyx).x - map(p-o.yyx).x));
}

float trace(vec3 o, vec3 r)
{
 	float t = 0.0;
    for (int i = 0; i < 32; ++i) {
        vec3 p = o + r * t;
        float d = map(p).x;
        t += d * 0.5;
    }
    return t;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 uv = fragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;
    
    vec3 r = normalize(vec3(uv, 0.25 - dot(uv,uv) * 0.33));
    r *= zrot(iTime);
	vec3 o = vec3(0.0, 0.0, -10.0);
    o.z += iTime;
    
    float t = trace(o, r);
    vec3 w = o + r * t;
    vec2 mp = map(w);
    float fd = mp.x;
    float it = mp.y;
    vec3 sn = normal(w);
    float prod = max(dot(sn,-r),0.0);
    
    vec3 lpos = o + vec3(0.0, 0.0, 4.0);
    vec3 ldir = normalize(lpos - w);
    float lprod = max(dot(sn,ldir), 0.0);
    vec3 ref = reflect(sn, ldir);
    float rprod = max(dot(r, ref), 0.0);
    rprod = pow(rprod, 4.0);

	float fog = 1.0 / (1.0 + t * t * 0.001);
    float edge = 1.0 / (1.0 + fd * 100.0);
    
	vec3 diff = 0.5 + 0.5 * vec3(1.0-cos(it), cos(it), sin(w.z));
    
    diff *= prod * 4.0;
    
    diff += rprod;
    
    diff *= fog * edge;
        
	fragColor = vec4(diff,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

