#version 330
#extension GL_EXT_gpu_shader4 : enable
//desertSandsMod01.fsh by foran
//https://www.shadertoy.com/view/3t2XRD
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//------------
const vec4 smokeColor=vec4(.75,.75,.75,.75);//color
const float rate=-1.;
const float zoom=5.;
const float depth=.54;
const float rxy=11.;
const float rxz=13.;

const vec2 center=vec2(-2,-1);

vec2 distort(vec2 p)
{
    float theta  = atan(p.y, p.x);
    float radius = length(p);
    radius = pow(radius, 1.0+depth);
    p.x = radius * cos(theta);
    p.y = radius * sin(theta);
    return 0.5 * (p + 1.0);
}
	
vec4 pattern(vec2 p)
{
	vec2 m=mod(p.xy+p.x+p.y,2.)-1.;
	return vec4(length(m+p*0.1));
}

float hash(const float n)
{
	return fract(sin(n)*29712.15073);
}

float noise(const vec3 x, float y, float z)
{
	vec3 p=floor(x); vec3 f=fract(x);
	f=f*f*(3.0-2.0*f);
	float n=p.x+p.y*y+p.z*z;
	float r1=mix(mix(hash(n+0.0),hash(n+1.0),f.x),mix(hash(n+y),hash(n+y+1.0),f.x),f.y);
    float r2=mix(mix(hash(n+z),hash(n+z+1.0),f.x),mix(hash(n+y+z),hash(n+y+z+1.0),f.x),f.y);
	return mix(r1,r2,f.z);
}
void main (void)
//void mainImage(out vec4 fragColor,in vec2 fragCoord)

 {
	
	float RY = 0.0;	float RZ = 0.0;
	if (rxy <= 1.)			{	RY += 11.;	}
	else if (rxy <= 2.)		{	RY += 13.; 	}
	else if (rxy <= 3.)		{	RY += 17.; 	}
	else if (rxy <= 4.)		{	RY += 19.; 	}
	else if (rxy <= 5.)		{	RY += 23.; 	}
	else if (rxy <= 6.)		{	RY += 29.; 	}
	else if (rxy <= 8.)		{	RY += 31.; 	}
	else if (rxy <= 9.)		{	RY += 37.; 	}
	else if (rxy <= 10.)	{	RY += 41.; 	}
	else if (rxy <= 11.)	{	RY += 43.; 	}
	else if (rxy <= 12.)	{	RY += 47.; 	}
	else if (rxy <= 13.)	{	RY += 53.; 	}
	else if (rxy <= 14.)	{	RY += 59.; 	}
	else if (rxy <= 15.)	{	RY += 61.; 	}
	else if (rxy <= 16.)	{	RY += 67.; 	}
	if (rxz <= 1.)			{	RZ += 11.; 	}
	else if (rxz <= 2.)		{	RZ += 13.; 	}
	else if (rxz <= 3.)		{	RZ += 17.; 	}
	else if (rxz <= 4.)		{	RZ += 19.; 	}
	else if (rxz <= 5.)		{	RZ += 23.; 	}
	else if (rxz <= 6.)		{	RZ += 29.; 	}
	else if (rxz <= 8.)		{	RZ += 31.; 	}
	else if (rxz <= 9.)		{	RZ += 37.; 	}
	else if (rxz <= 10.)	{	RZ += 41.; 	}
	else if (rxz <= 11.)	{	RZ += 43.; 	}
	else if (rxz <= 12.)	{	RZ += 47.; 	}
	else if (rxz <= 13.)	{	RZ += 53.; 	}
	else if (rxz <= 14.)	{	RZ += 59.; 	}
	else if (rxz <= 15.)	{	RZ += 61.; 	}
	else if (rxz <= 16.)	{	RZ += 67.; 	}
	
	vec2 pos = ( gl_FragCoord.xy / iResolution.xy * zoom )+center;
	vec4 inputPixel=texture2D(iChannel0,pos);
	
	float col=noise(pos.yyx+(iTime*rate),RY,RZ);
	
	vec4 c=pattern(distort(pos+col));
	  c.xy = distort(c.xy);
	  inputPixel.xy=distort(inputPixel.xy);
	
	
vec4 final=mix(vec4(inputPixel.rgb,max(c.xy,inputPixel.a)),inputPixel*c,pow(abs(col),pow(inputPixel.a*col,2.)));
gl_FragColor=final;
}