#version 330
#extension GL_EXT_gpu_shader4 : enable
//LavatextureMod01.fsh  by   ihal
//https://www.shadertoy.com/view/ldcBzB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.62821   //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
Lava texture based on Fractal Brownian motion + domain warping as described by
https://thebookofshaders.com/13/

The fbm is thresholded to generate floating rocks.

Colorblending modes (for glow etc) are based on their implementations in Adobe Photoshop.
*/

//-------------------------------------------------
// Define colorscheme
//-------------------------------------------------
const vec3 orange = vec3(0.65, 0.37, 0);
const vec3 middleRed1 = vec3(.5882, .2451, .1922);
const vec3 middleRed2 = vec3(.8196, .3451, .3176);

//-------------------------------------------------
// Noise & random-functions
//-------------------------------------------------

float rand(vec2 st){
    //https://thebookofshaders.com/13/
    return fract(sin(dot(st,
                         vec2(12.9898,78.233)))*
        43758.5453123);
}

float noise(vec2 x) {
    //https://thebookofshaders.com/11/
    vec2 i = floor(x);
    vec2 f = fract(x);
    float y = rand(vec2(.5));
    float a = rand(i);
    float b = rand(i + vec2(1., 0.0));
    float c = rand(i + vec2(0.0, 1.));
    float d = rand(i + vec2(1., 1.));
    vec2 u = smoothstep(0.0, 1.0, f);
    return mix(a, b, u.x) +
            (c - a)* u.y * (1.0 - u.x) +
            (d - b) * u.x * u.y;
}

float fbm(vec2 st) {
    //https://thebookofshaders.com/13/
    float value = 0.0;
    float amplitude = .5;
    float frequency = 0.;
    // Loop of octaves
    for (int i = 0; i < 10; i++) {
        value += amplitude * noise(st);
        st *= 2.2;
        amplitude *= .5;
    }
    return value;
}
//-------------------------------------------------
// Some useful functions for changing colors etc
//-------------------------------------------------
vec3 rgbToYuv(vec3 rgb) {
    mat3 transformation = mat3(0.299, 0.587, 0.114, 
                               -0.14713, -0.28886, 0.436,
                              0.615, -0.51499, -0.10001);
    return transformation * rgb;
}
vec3 yuvToRgb(vec3 yuv) {
    mat3 transformation = mat3(1.0, 0.0, 1.13983, 
                               1.0, -0.39465, -0.5806,
                              1.0, 2.03211, 0.0);
    return transformation * yuv;
}
vec3 colorDodge(vec3 color) {
    //https://photoblogstop.com/photoshop/photoshop-blend-modes-explained
    vec3 dodgeBy = vec3(.5, .5, .5);
    dodgeBy = vec3(1.0, 1.0, 1.0) - dodgeBy;
    color /= dodgeBy;
    return color;
}
vec3 colorBurn(vec3 color, vec3 burnBy) {
    color = vec3(1.0, 1.0, 1.0) - color;
    color /= burnBy;
    return vec3(1.0, 1.0, 1.0) - color;
}
vec3 colorBurn(vec3 color) {
    return colorBurn(color, vec3(.6));
}
vec3 colorScreen(vec3 bgcolor, vec3 addcolor) {
    vec3 onevector = vec3(1.0, 1.0, 1.0);
    bgcolor = onevector - bgcolor;
    addcolor = onevector - bgcolor;
    return onevector - (bgcolor * addcolor);
}
vec3 colorMultiply(vec3 bgcolor, vec3 addcolor) {
    return bgcolor * addcolor;
}
vec3 colorOverlay(vec3 bgcolor, vec3 addcolor) {
   	vec3 yuvBg = rgbToYuv(bgcolor);
    if (yuvBg.x > 0.5) {
        return colorScreen(bgcolor, addcolor);
    }
    else {
        return colorMultiply(bgcolor, addcolor);
    }    
}

//-------------------------------------------------
// Start of lava-specific stuff
//-------------------------------------------------

float getFlowSpots(vec2 uv, float sizeOfTexture) {
    //Based on https://thebookofshaders.com
    vec2 q = vec2(0.);
    q.x = fbm( uv + .5 * iTime); //Some wobbliness (fake heat)
    q.y = fbm( uv + vec2(1.0));
    
	float speed = .1;
    float wobbliness = .02;
    vec2 r = vec2(0.);
    r.x = .5 * fbm(.1* (uv + 1.0*q + vec2(5.,1.2) + wobbliness*iTime) );
    r.y = speed * iTime + 1.01 * fbm(.1 * uv + wobbliness * iTime);
	float flowFactor = fbm(sizeOfTexture * (uv + r));
    return flowFactor;
}

float getFlowSpots(vec2 uv, float sizeOfTexture, float speed) {
    //Based on https://thebookofshaders.com
    uv.y /= 1.2;
    //uv.x /= 1.5;
    vec2 q = vec2(0.);
    q.x = fbm( uv + .5 * iTime); //Some wobbliness (fake heat)
    q.y = fbm( uv + vec2(1.0));
    
	//float speed = .4;
    float wobbliness = .05;
    vec2 r = vec2(0.);
    r.x = .5 * fbm(.2* (uv + 1.0 * q + vec2(5.,1.2) + wobbliness*iTime) );
    r.y = speed * iTime + .2 * fbm(3.8 * uv + wobbliness * iTime);
	float flowFactor = fbm(1.5 * (uv + r) * .9);
    //flowFactor = clamp(flowFactor, .4, 1.7);
    return flowFactor;
}

//Something more interesting can be done here
float getLavaStoneTexture(vec2 uv, float f) {
    return getFlowSpots(uv, f);
}

vec3 getColorOfDots(vec2 uv, float f) {
    vec3 flowColor = colorBurn(middleRed1, .8 * vec3(f));
	float f2 = smoothstep(.4, 1., f);
    f2 = smoothstep(0., 1., f);
    flowColor = mix(colorDodge(orange), flowColor, f2);
    f = smoothstep(.4, 1., f);
    flowColor = mix(flowColor, flowColor * .3, f);
    flowColor = mix(flowColor, colorMultiply(flowColor, vec3(.5)), getLavaStoneTexture(uv, 94.4));
    return flowColor;
}

//Not entirely happy with the look; looks too much like clouds rather than a fluid.
vec3 getColorOfBackgroundFlow(vec2 uv, float f) {
    f = 1. - sin(f);
    vec3 flowColor = colorBurn(middleRed1, vec3(f));
	float f2 = smoothstep(.4, 1., f);
    f2 = smoothstep(0., 1., f);
    flowColor = mix(colorDodge(orange), flowColor, f2);
    f = smoothstep(.2, 1., f);
    flowColor = mix(flowColor, flowColor * .3, f);
    //flowColor = mix(flowColor, colorMultiply(flowColor, vec3(.5)), getLavaStoneTexture(uv, 10.));
    
    return  flowColor;
}

vec3 addGlowOfSpots(vec2 uv, float f, vec3 flowColor) {
    vec3 glowColor = mix(orange, flowColor, smoothstep(.7, 1., f));
    glowColor = mix(colorDodge(glowColor), flowColor, smoothstep(.9, 1., f));
    return mix(flowColor, glowColor, smoothstep(.1, .8, f));
}

float lavaEdgeAnimator(float edge, vec2 uv) {
	float edgeMovement = 0.5 * (sin(iTime/2.0 + uv.y) + 1.0) * 0.3;
    float mySin = .7 * (sin(iTime + uv.y) + 1.0);
    float mySin2 = .7 * (sin(iTime + uv.y + 2.1415) + 1.0);
    edge += mySin * edgeMovement; 
    edge += mySin2 * edgeMovement;
	return edge;
}

vec3 addGlowToEdges(vec2 uv, float f, vec3 flowColor) {
    float uvScaler = iResolution.x/iResolution.y;
    float MWF = .1 * f * getFlowSpots(uv, 30.); 
    float edges = smoothstep(0.0 + .1 * MWF, MWF * 2., uv.x) - 
        smoothstep((1. - MWF) * uvScaler, (1.0 - .1 * MWF) * uvScaler, uv.x);
    float edges2 = smoothstep(0.0 + .1 * MWF, MWF, uv.x) - 
        smoothstep((1. - MWF * .5) * uvScaler, (1.0 - .05 * MWF) * uvScaler, uv.x);
    edges = lavaEdgeAnimator(edges, uv);
    edges2 = lavaEdgeAnimator(edges2, uv);
    //flowColor = mix(orange, flowColor, clamp(edges, .0, 1.));
    flowColor = mix(orange, flowColor, clamp(edges2, .2, 1.));
    return mix(colorDodge(flowColor), flowColor, clamp(edges, .2, 1.));
}

float filterEdgesOfLava(float f, vec2 uv) {
    //We want the floating stuff to stay out of the edges.
    //There should be a better way to do this though!
    float uvScaler = iResolution.x/iResolution.y;
    float MWF = .003 + .2 * f; 
    float edges = smoothstep(0.0 + .7 * MWF, MWF, uv.x) - 
        smoothstep((1. - MWF) * uvScaler, (1.0 - .3 * MWF) * uvScaler, uv.x);
    f = mix(1.0, f, clamp(edges, .0, 1.));
    return f;
}

float filterFlowToTexture(float f, vec2 uv) {
    f += smoothstep(.3, .5, f) * .8 * (1. - f);
    f = smoothstep(0., 1., f);
    f = filterEdgesOfLava(f, uv);
    return f;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    uv.x *= iResolution.x/iResolution.y;
    
	float textureFlowSpots = getFlowSpots(uv, 4.4);
    float textureBg = getFlowSpots(uv, 2.4, .13);
    float spotBgDivider = 1. - textureFlowSpots;
    spotBgDivider = filterFlowToTexture(spotBgDivider, uv);
    
    vec3 color = mix(getColorOfBackgroundFlow(uv, textureBg), getColorOfDots(uv, textureFlowSpots), step(spotBgDivider, .5));
	color = addGlowOfSpots(uv, spotBgDivider, color);
    color = addGlowToEdges(uv, textureFlowSpots, color);
    
    gl_FragColor = vec4(color, 1.);
    /*
	//PRESENTATION DEMOS
    //Thresholded demo
    gl_FragColor = vec4(vec3(spotBgDivider), 1.);
    //Background FBM + warping demo
    gl_FragColor = vec4(vec3(textureBg), 1.);
    //FBM + warping demo
    gl_FragColor = vec4(vec3(textureFlowSpots), 1.);
    //FBM demo
    gl_FragColor = vec4(vec3(fbm(uv * 5.)), 1.);
    //Noise demo
    gl_FragColor = vec4(vec3(noise(uv * 5.)), 1.);
	*/
}
