#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// FireworksMod01.fsh   by    ilyaev 
//https://www.shadertoy.com/view/wslcWN
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define SPARKS 30
#define FIREWORKS 8.
#define BASE_PAUSE FIREWORKS / 30.
#define PI 3.14
#define PI2 6.28

float n21(vec2 n) {
    return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);
}

vec2 randomSpark(float noise) {
    vec2 v0 = vec2((noise - .5) * 13., (fract(noise * 123.) - .5) * 15.);
    return v0;
}

vec2 circularSpark(float i, float noiseId, float noiseSpark) {
    noiseId = fract(noiseId * 7897654.45);
    float a = (PI2 / float(SPARKS)) * i;
    float speed = 10.*clamp(noiseId, .7, 1.);
    float x = sin(a + iTime*((noiseId-.5)*3.));
    float y = cos(a + iTime*(fract(noiseId*4567.332) - .5)*2.);
    vec2 v0 = vec2(x, y) * speed;
    return v0;
}


vec2 rocket(vec2 start, float t) {
    float y = t;
    float x = sin(y*10.+cos(t*3.))*.1;
    vec2 p = start + vec2(x, y * 8.);
    return p;
}

vec3 firework(vec2 uv, float index, float pauseTime) {
    vec3 col = vec3(0.);


    float timeScale = 1.;
    vec2 gravity = vec2(0., -9.8);

    float explodeTime = .9;
    float rocketTime = 1.1;
    float episodeTime = rocketTime + explodeTime + pauseTime;

    float ratio = iResolution.x / iResolution.y;

    float timeScaled = (iTime - pauseTime) / timeScale;

    float id = floor(timeScaled / episodeTime);
    float et = mod(timeScaled, episodeTime);

    float noiseId = n21(vec2(id+1., index+1.));

    float scale = clamp(fract(noiseId*567.53)*30., 10., 30.);
    uv *= scale;

    rocketTime -= (fract(noiseId*1234.543) * .5);

    vec2 pRocket = rocket(vec2(0. + ((noiseId - .5)*scale*ratio), 0. - scale/2.), clamp(et, 0., rocketTime));

    if (et < rocketTime) {
        float rd = length(uv - pRocket);
        col += pow(.05/rd , 1.9) * vec3(0.9, .3, .0);
    }


    if (et > rocketTime && et < (rocketTime + explodeTime)) {
        float burst = sign(fract(noiseId*44432.22) - .6);
        for(int i = 0 ; i < SPARKS ; i++) {
                vec2 center = pRocket;
                float fi = float(i);
                float noiseSpark = fract(n21(vec2(id*10.+index*20., float(i+1))) * 332.44);
                float t = et - rocketTime;
                vec2 v0;

                if (fract(noiseId*3532.33) > .5) {
                    v0 = randomSpark(noiseSpark);
                    t -= noiseSpark * (fract(noiseId*543.) * .2);
                } else {
                    v0 = circularSpark(fi, noiseId, noiseSpark);

                    if ( (fract(noiseId*973.22) - .5) > 0.) {
                        float re = mod(fi, 4. + 10. * noiseId);
                        t -= floor(re/2.) * burst * .1;
                    } else {
                        t -= mod(fi, 2.) == 0. ? 0. : burst * .5*clamp(noiseId, .3, 1.);
                    }
                }

                vec2 s = v0*t + (gravity * t * t) / 2.;

                vec2 p = center + s;

                float d = length(uv - p);

                if (t > 0.) {
                    float fade = clamp((1. - t/explodeTime), 0., 1.);
                    vec3 sparkColor = vec3(noiseId*.9, .5*fract(noiseId *456.33), .5*fract(noiseId *1456.33));
                    vec3 c = (.05 / d) * sparkColor;
                    col += c * fade;
                }
            }
    }


    return col;
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoords )
{ 
    vec2 uv = fragCoords.xy / iResolution.xy;
    uv -= .5;
    uv.x *= iResolution.x / iResolution.y;

    vec3 col = vec3(0.);

    for (float i = 0. ; i < FIREWORKS ; i += 1.) {
        col += firework(uv, i + 1., (i * BASE_PAUSE));
    }


    fragColor = vec4(col, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

