#version 330
#extension GL_EXT_gpu_shader4 : enable
// clover-snakeMod01.fsh  by   javalang

//https://www.shadertoy.com/view/MsdSDN
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//mix from https://www.shadertoy.com/view/XsXGzn
//and https://www.shadertoy.com/view/MsBSDz

//#define LUCKY
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    vec3 col = vec3(1.0,1.0,1.0);
    float time = iTime*.2;

	for(int i = 20; i>0; i--)
    {     
        vec2 shape = uv - vec2(.5,.45);  
        shape.x+=cos(float(i)/3.5-time*1.3)/2.5;
        shape.y+=sin(float(i)/2.5-time*1.7)/2.5;

        vec2 sh2=shape*vec2(2.,1.2);//*2.-1.;
        float t=iTime*1.5;
        float lucky=1.0;
#ifdef LUCKY
        lucky=1.3;
#endif    
    	float a = atan(sh2.x,sh2.y)*lucky;
    	float r = length(sh2);
    	float s = 0.5 + 0.5*sin(3.0*a + t);
    	float g = sin(1.57+3.0*a+t);
    	float d = 0.15 + 0.3*sqrt(s) + 0.15*g*g;
    	float h = clamp(2.*r/d,0.0,1.0);
    	float f = 1.0-smoothstep( 0.95, 1.0, h );
    	h *=1.0-0.5*(1.0-h)*smoothstep(0.95+0.5*h,1.0,sin(3.0*a+t));
        col *= h;
        col.y+=.02;
        col = mix( col, 1.2*vec3(0.1*h,0.12+0.5*h,0.1), f-.01 );
    }
    gl_FragColor = vec4(col,1.0);
}