#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//sphereletMod01.fsh by   jt
//https://www.shadertoy.com/view/slyfz1
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// https://www.shadertoy.com/view/slyfz1 spherelet by jt

// A lightweight fake sphere - for applications  where ray-tracing / ray-marching would be overkill.

// MIT License, as in https://www.shadertoy.com/terms

/*

Copyright (c) 2022 Jakob Thomsen

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#define pi 3.1415926

vec3 checker(vec3 c0, vec3 c1, vec2 p)
{
    //p = fract(p) - 0.5;
    p = sin(2.0 * pi * p);
    //vec2 edges = (1.0 - exp2(-p*p*1000.0)); // edges used to hide aliasing
    vec2 edges = (1.0 - exp2(-p*p*iResolution.xy/1.0)); // edges used to hide aliasing
    return mix(c0, c1, step(0.0, p.x * p.y)) * edges.x * edges.y;
}

// returns normal of either sphere (n, 1) or background plane (n, 0)
vec4 sphere_normal(vec2 p)
{
    float t = 1.0 - p.x * p.x - p.y * p.y;
    //float choose = t < 0.0 ? 0.0 : 1.0;
    float choose = smoothstep(0.0, 0.02, t);
    vec3 normal_plane = vec3(0,0,1);
    if(t < 0.0) // avoid NaN later on
        return vec4(normal_plane, 0.0); // background plane
    vec3 normal_sphere = normalize(vec3(p.x, p.y, sqrt(t)));
    //return vec4(normal_sphere, 1.0); // sphere
    return vec4(mix(normal_plane, normal_sphere, step(0.0, t)), choose); // antialiased version
}

vec4 sphere_lighted(vec2 p, vec3 c0, vec3 c1, vec2 t, vec3 l) // (could be parametrized further)
{
    vec3 rd = vec3(p, 1.0);

    vec4 r = sphere_normal(p);
    vec3 n = vec3(r);
    vec3 h = normalize(l + normalize(rd));
    float specular = pow(max(dot(h, n), 0.0), 50.0);
    //float diffuse = 0.5 * max(dot(n, l), 0.0); // correct
    float diffuse = max((0.5 * dot(n, l)) + 0.5, 0.0); // hack: light goes "around" a bit
    float ambient = 0.0;

    //vec2 q = vec2(0.5 - 0.5 * atan(n.z, n.x) / PI, -0.5 + 0.5 * p.y);
    // https://en.wikipedia.org/wiki/Mercator_projection
    vec2 q = vec2(0.5 - 0.5 * atan(n.z, n.x) / pi, 1.0-acos(n.y) / pi); // looks ok but is this correct?
    q.y = (1.0 - n.z/5.0/*cam-dist*/) * (2.0 * q.y - 1.0) * 0.5 + 0.5; // perspective
    vec3 color = (ambient + diffuse) * checker(c0, c1, vec2(iTime / 10.0, 0.0) + q * t);
    color += specular * 0.75;

    return vec4(color, r.w);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 p = (2.0 * fragCoord - iResolution.xy) / iResolution.y;

    vec3 l = normalize(vec3(1.0, 1.0, 1.0));
    //vec3 l = vec3(sin(iTime), 0.0, cos(iTime));
    vec4 s = sphere_lighted(p, vec3(0.1), vec3(0.9), vec2(6.0, 4.0), l);
    //vec4 s = sphere_lighted((p+0.5)*2.0, vec3(0.1), vec3(0.9), vec2(6.0, 4.0), l);
    vec3 color = mix(vec3(0.0), vec3(s), s.w);

    fragColor = vec4(sqrt(color), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

