#version 330
#extension GL_EXT_gpu_shader4 : enable
//Fuzz-flakesMod01.fsh  by   mmclin
//https://www.shadertoy.com/view/3tj3zD
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Fuzz-flakes by Matt McLin

// random func based on one found here: https://thebookofshaders.com/10/
// @patriciogv - 2015, http://patriciogonzalezvivo.com
float rand (float seed) 
{
    return fract(sin(dot(vec2(seed, seed*0.5926535897),
                         vec2(12.9898,78.233)))*43758.5453123);
}

float flake(in vec2 uv, in vec2 pos, float speed, float size, float wind)
{
    uv.x *= 1.6;
    vec2 drop;
    drop.y = 1.0 - fract(((iTime+pos.y)*speed) / iResolution.y);
    drop.x = (pos.x * 1.6) + sin(drop.y*wind)*0.1;
    float d = distance(uv, drop);
    d = clamp(d, 0.0, 0.28);
    if (d < size) return 1.0;
    if (d > (size+0.02)) return 0.0;
    return mix(1.0,0.0, 50.0*(d - size));
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    vec3 col = vec3(0.3,0.1,0.7) - 0.2*cos(iTime+uv.xyx);
    
    for (float i=0.0; i<200.0; i += 1.0) {
        vec3 flakecol = vec3(0.3+0.3*rand(i*0.9),0.7+0.3*rand(i*0.3),0.8+0.2*rand(i*0.6));
        vec2 pos = vec2(rand(i), rand(i*0.887787)*1.6 + 0.1);
        float speed = 150.0 + 100.0*rand(i*0.728734);
        float size = 0.005 + 0.02*rand(i*0.1415926);
        float wind = 4.0*rand(i*0.314159);
        col = mix(col, flakecol, flake(uv, pos, speed, size, wind));
    }

    gl_FragColor = vec4(col,1.0);
}
