#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// PsycheyeMod01.fsh  by   rubioh  
//https://www.shadertoy.com/view/ftGfWV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.141593

vec3 palette(float t, vec3 a, vec3 b, vec3 c, vec3 d )
{
    return a + b*cos(6.28318*(c*t+d));
}

vec2 hash( vec2 p )
{
    //p = mod(p, 4.0); // tile
    p = vec2(dot(p,vec2(175.1,311.7)),
             dot(p,vec2(260.5,752.3)));
    return fract(sin(p+455.)*18.5453);
}

vec2 hash2( vec2 p ) 
{
    const vec2 k = vec2( 0.3183099, 0.3678794 );
    float n = 111.0*p.x + 113.0*p.y;
    return fract(n*fract(k*n));
}
float noise(in vec2 st) {
    vec2 i = floor(st);
    vec2 f = fract(st);
    float a = hash2(i).x;
    float b = hash2(i + vec2(1.0, 0.0)).x;
    float c = hash2(i + vec2(0.0, 1.0)).x;
    float d = hash2(i + vec2(1.0, 1.0)).x;
    vec2 u = f*f*(3.0-2.0*f);
    return mix(a, b, u.x) +
            (c - a)* u.y * (1.0 - u.x) +
            (d - b) * u.x * u.y;
}

float fbm( in vec2 x)
{    
    float t = 0.0;
    float amp = 0.;
    for( int i=1; i<7; i++ )
    {
        float f = pow( 2., float(i) );
        float a = pow( f, -.75 );
        amp = 10.*step(3., float(i));
        t += a*noise(f*x+amp);
    }
    return t*1.-.4;
}
vec2 make_eye(vec2 uv){
    float area_eye = smoothstep(140./iResolution.y, 0., abs(abs(uv.y) - (.1*cos(iTime)+.9)*sin(uv.x+PI/2.))-.15);
    return vec2(area_eye, // contour
              smoothstep(140./iResolution.y, 0., abs(uv.y) - (.1*cos(iTime)+.9)*sin(uv.x+PI/2.))// inside
            );
}

vec2 make_pupil(vec2 uv, vec2 center, float radius){
    return vec2(
        smoothstep(5./iResolution.y, 0., abs(length(uv+-center)-radius)-.02), // Pupille contour
        1.-smoothstep(-5./iResolution.y, 0., (length(uv-center)-radius)-.02)); // Pupille inside
}

vec3 red_pupil(vec2 uv, vec2 center, float radius){
    return vec3(
        1.-smoothstep(0., radius/3., length(uv-center)), 0., 0.); // Pupille inside
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = ( 2.*fragCoord.xy - iResolution.xy ) / iResolution.y;
    uv *= 1.5;
    // Time varying pixel color
    vec2 center = vec2(0., 0.);
    float radius = .2+.1*cos(iTime*.3);
    
    
    
    vec2 pupille = make_pupil(uv, center, radius);
    vec2 eye = make_eye(uv);
    
    vec2 st = (uv-center)*(3.);
    
    
    float N = cos(iTime*.8)+ 2.;
    
    float length_st = pow( pow(abs(st.x), N) + pow(abs(st.y), N), 1./N);
    float n = noise(vec2(length_st, length_st) - .2*iTime)*5.+fbm(abs(st)-iTime+fbm(abs(st))) ;
    
    // iq's palette
    vec3 a = vec3(0.5, 0.5, 0.5);
    vec3 b = 1.-a;
    vec3 c = vec3(.3, .3, .3);
    vec3 d = vec3(0.0, 0.1, 0.2);
    vec3 iris = palette(n, a,b,c,d)*eye.y* (1. - pupille.y) + vec3(.3)*pupille.x;
    
    /*
    vec3 a = vec3(0.5, 0.5, 0.5);
    vec3 b = 1.-a;
    vec3 c = vec3(.3, .3, .3);
    vec3 d = vec3(0.0, 0.1, 0.2);
    vec3 iris = palette(n, a,b,c,d)*eye.y* (1. - pupille.y);
    */    
    
    
    
    vec3 col = iris;

    // Output to screen
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

