#version 330
#extension GL_EXT_gpu_shader4 : enable
//Arrows1Mod01.fsh by rudros
//https://www.shadertoy.com/view/7ddSDB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.1415326

mat2 rotate2D(float r) {
    return mat2(cos(r), sin(r), -sin(r), cos(r));
}

// Distance of point p to ring #ringNum
float distanceTo(vec3 p, float size) {
//    p.xz = abs(abs(p.xz)-size*2.2)*rotate2D(PI/6.);
    p.y += size;  // Ring location
    return length(p-clamp(p,-size,size));
}

// Closest point of all the rings
float worldSDF(vec3 p) {
    float minDist = 1.;
    for(float j=6.; j>0.; j--) { // Number of rings
        float size = exp(-j);  // Ring size
        p.xz = abs(abs(p.xz)-size*2.2)*rotate2D(PI/6.); // Mutation affects the following rings, so can't be moved above
        float curDist = distanceTo(p, size);
        minDist = min(minDist, curDist); 
    }
    return minDist;
}

vec3 cameraMotion(vec3 p) {
    p.yz *= rotate2D(-0.8);
    p.xz *= rotate2D(iTime);
    return p;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
    float i;
    float minDist, eyeDist;

    vec3 eyePos = vec3(0, 0, -1);
    vec3 ray = vec3((gl_FragCoord.xy-.5*iResolution.xy)/iResolution.x, 1.);
    ray = normalize(ray);

    // Camera motion
    eyePos = cameraMotion(eyePos);
    ray = cameraMotion(ray);

    for(minDist=1.; i<100. && minDist>.001; i++) {  
        // Point to check
        vec3 p = eyePos+eyeDist*ray;
        
        minDist = worldSDF(p);
        // Move point forward
        eyeDist += minDist*.5;
    }
    // Adjust steps by current distance to surface to fix banding
    i += minDist*2000.;
    gl_FragColor = vec4(0) + 100./(i*i);
}
