#version 330
#extension GL_EXT_gpu_shader4 : enable
//square_flipMod01.fsh  by  sporadiclizard
//
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
// 2*pi
#define TAU 6.283185307179

vec2 cxmul(vec2 z, vec2 w) {
    return mat2(z, -z.y, z.x) * w; //vec2(z.x*w.x - z.y*w.y, z.x*w.y + z.y*w.x);
}

vec2 cxdiv(vec2 z, vec2 w) {
    return cxmul(z, vec2(w.x, -w.y)) / dot(w,w);
}

vec2 mobius(vec2 z, vec2 a, vec2 b, vec2 c, vec2 d) {
    return cxdiv(cxmul(a,z) + b, cxmul(c,z) + d); 
}

// mobius transformation described with which complex numbers 
// it sends zero, one and infinity to.
// 0 -> q, 1 -> r, inf -> s
vec2 mobi3(vec2 z, vec2 q, vec2 r, vec2 s) {
    return cxdiv(cxmul(z - q, r - s), cxmul(z - s, r - q));
}

vec2 rotate(vec2 v, float a) {
  float s = sin(a);
  float c = cos(a);
  mat2 m = mat2(c, -s, s, c);
  return m * v;
}

const float scale = 1.5;
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
 	float time = iTime*0.25;
    
    // centered around origin, [-1, 1];
    vec2 pos = ( 2. * gl_FragCoord.xy - iResolution.xy ) / iResolution.y; 
    
    vec2 zero = vec2( .15, 0.);
    vec2 one =  vec2( -.15, 0.);
    vec2 inf =  vec2( 0., 1.5);

    // mobius transformed position - deforms the plane 
    vec2 posi = mobi3(pos, zero, one, inf);
  	
    // switch for the two phases of the animation
    // 0 for 0 < (iTime % 2) < 1
    // 1 for 1 < (iTime % 2) < 2 
    float sw = mod(floor(2.*time),2.);

    // make a grid with the inverted position
    // the switch moves the grid for when the visual "switch" happens
    vec2 gposi = -1. + 2. * fract((scale*posi + sw*0.5 - time));
    
    // eased time for smooth rotation anim 
    float eased = 0.5*(1.-cos(mod(time,0.5)*TAU));
    // switch direction for the two phases of the animation
    eased *= mix(1., -1., sw);
    gposi = rotate(gposi, eased*TAU/4.);
    
    // distance function for a 45 degree rotated square, or a diamond
    float diamond = smoothstep(0., 1., (abs(gposi.x)+abs(gposi.y))*0.5);
    
    // this flips the colors of the diamond for the different phases of the anim
    // together with the grid movement, this produced the visual "switch"
    // from black squares on white bg to white squares on black bg
    float switchedDiamond = 2. * mix(1.-diamond, diamond, sw);
    
    // use the distance func to make squares 
    // float colVal = pow(switchedDiamond, 20.);

    // antialiased version by FabriceNeyret2 - Thank you!
    // it blurs the edges more where the squares are smaller  
    float b = 40. / ( iResolution.y * length(pos-vec2(0.,1.)) ); 
    float colVal = smoothstep(-b,b,switchedDiamond-1.);

    // Output to screen
    gl_FragColor = vec4(vec3(colVal),1.0);
}