#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Quicky#043Mod01.fsh   by   totetmatt    
//https://www.shadertoy.com/view/WlSBzR
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
Function from IQ website and http://mercury.sexy/
Based on Flopine last stream
*/
#define ITER 64.
#define PI 3.141592
#define beat iTime
#define acc 2.
#define ttime (floor(beat)+pow(fract(beat),.5))
#define pal(x) palette( x, vec3(0.8,0.5,0.4),vec3(0.2,0.4,0.2),vec3(2.0,1.0,1.0),vec3(0.0,0.25,0.25) )
struct obj{
    float d;
    int mat;
    vec3 col;
};
vec3 palette(float t,vec3 a,vec3 b,vec3 c,vec3 d ) {
    return a + b*cos( 6.28318*(c*t+d) );
}


mat2 r(float a){
    float c=cos(a),s=sin(a);
    return mat2(c,s,-s,c);
}

vec3 iri(vec3 c, vec3 n, vec3 rd, vec3 col){
    float fresnel = max(1.-dot(n,rd),0.);
    c += pal(fresnel+length(col));
     
    return c;
}
void mo(inout vec2 p,vec2 d){
  p = abs(p)-d;
  if(p.y>p.x) p = p.yx;
}
float box(vec3 p, vec3 c,float sm){
    return length(max(abs(p)-c, 0.))-(sm);
}

float pModPolar(inout vec2 p, float repetitions) {
    float angle = 2.*PI/repetitions;
    float a = atan(p.y, p.x) + angle/2.;
    float r = length(p);
    float c = floor(a/angle);
    a = mod(a,angle) - angle/2.;
    p = vec2(cos(a), sin(a))*r;
    if (abs(c) >= (repetitions/2.)) c = abs(c);
    return c;
}

obj liane(vec3 p){

  p.yz*=r(PI/2.+sin(iTime+(p.z*.3)*.5)*.1);

     p.xz *=r(+p.y*.1+cos(p.y*.1+iTime*.15));
pModPolar(p.xz,10.);
  p.x-=sin(ttime+p.y*.4+atan(p.x,p.y)*2.)*.5+.5;
  p-=vec3(1.51,.0,.0);
   p.xz *=r(sin(p.y*2.+iTime));
   
   pModPolar(p.xz,3.);

    float cd = box(p,vec3(.2,20.2,.2),.0);
    if(sin(p.z*10.+p.y*.9+iTime*3.)>=.9){
     return obj(cd,1,vec3(.5,0.5,-0.0));
    }else
    return obj(cd,2,vec3(0.1,0.9,0.3));
}
obj fig(vec3 p){
     p.z-=7.;
     p.xy *=r(iTime);
     pModPolar(p.xy,3.);
     p.yz *=r(-iTime);
     mo(p.xy,vec2(4.9));
     mo(p.yz,vec2(0.5));
    float cd = box(p,vec3(.5,.7,.1),.1);
    cd = abs(cd)-.1;
    return obj(cd,1,vec3(-0.50,.9,-.1)*.2);
}
obj mino(obj a, obj b){
    if(a.d < b.d) return a;
    return b;
}

obj SDF(vec3 p) {return mino(liane(p),fig(p));}


vec3 norm(vec3 p){
    vec2 eps = vec2(.0001,0.);
    return normalize(SDF(p).d - vec3(   SDF(p-eps.xyy).d,
                                        SDF(p-eps.yxy).d,
                                        SDF(p-eps.yyx).d) );
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
     
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
     
    vec3 ro =vec3(0.,0.,-7.),
    p = ro,
    rd = normalize(vec3(uv,1.)),
    col = vec3(0);
   
     
    obj O ;
    bool hit = false;
    float shad;
    float t=0.;
    for(float i=0.;i < ITER; i++) {
        p = ro + t*rd;
        O = SDF(p);
        if(O.d< 0.01) {
            hit = true;
            shad = i / ITER;
            break;
        }
        t+=O.d;
    }
    
    if(hit) {
        vec3 n = norm(p);
        if(O.mat == 1) col = iri(O.col,n, rd, vec3(.0,.34,.60)); 
   
        if(O.mat == 2) col =  O.col*(1.-shad);
    
    }

    fragColor = vec4(clamp((col),0.,1.),1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

