#version 330
#extension GL_EXT_gpu_shader4 : enable
//26_100Mod01.fsh  by   yahe
//https://www.shadertoy.com/view/XdXBRB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Based on Dessert Chase https://www.shadertoy.com/view/Msf3DB

#define MOD3 vec3(.1031,.11369,.13787)

//  1 out, 2 in...
float hash12(vec2 p) {
	vec3 p3  = fract(vec3(p.xyx) * MOD3);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}
    
float pn(vec3 p) {
	//noise function by CPU https://www.shadertoy.com/view/4sfGRH
    vec3 i = floor(p); 
	vec4 a = dot(i, vec3(1., 57., 21.)) + vec4(0., 57., 21., 78.);
    vec3 f = cos((p-i)*3.141592653589793)*(-.5) + .5;  
	a = mix(sin(cos(a)*a), sin(cos(1.+a)*(1.+a)), f.x);
    a.xy = mix(a.xz, a.yw, f.y) + sin(iTime);   
	return mix(a.x, a.y, f.z);
}

float getNoise(vec2 pos, float pulse) {
	vec3 q = vec3(pos * 2., pos.x-pos.y + iTime * 0.3);
	float b = (pulse * 1.6) + pn(q * 2.) + 2.8;
	b +=  .25 * pn(q * 4.);
	b +=  .25  * pn(q * 8.);
	b +=  .5  * pn(vec3(pos, pos.x-pos.y + iTime * 0.3) * 12.23);
	b = pow(b,0.5);	
	return b;
}

vec2 rotate(vec2 uv, float d)
{
	vec2 tuv = uv;		
	uv.x = tuv.x*cos(d)-tuv.y*sin(d);
	uv.y = tuv.x*sin(d)+tuv.y*cos(d);
	return uv;
}


float stars(vec2 uv, float t) {
    t*=3.;
    
    float n1 = hash12(uv*10000.);
    float n2 = hash12(uv*11234.);
    float alpha1 = pow(n1, 20.);
    float alpha2 = pow(n2, 20.);
    
    float twinkle = sin((uv.x-t+cos(uv.y*20.+t))*10.);
    twinkle *= cos((uv.y*.234-t*3.24+sin(uv.x*12.3+t*.243))*7.34);
    twinkle = (twinkle + 1.)/2.;
    return alpha1 * alpha2 * twinkle;
}

vec3 sky(vec2 uv)
{
    float t = iTime;
    vec3 f = vec3(0.005, 0.1, 0.2);
    vec3 w = vec3(sin(uv.y*2.1-t*1.345)*0.2,sin(uv.y*1.1-t)*0.2,sin(uv.y*7.5-t*3.123)*0.01);
    
    vec3 col = smoothstep(-0.6+w,1.4+w+f,uv.yyy);
    
    col += stars(uv, iTime*.05);
	
	return col;
}

float sdPlane( vec3 p )
{
	return p.y + 0.06*(sin(iTime)+2.);
}

float dunes(in vec3 pos)
{
	return 0.6 * sin(pos.z + pn(pos))* sin(pos.x);
}

vec2 map(in vec3 pos)
{
	return vec2(sdPlane(pos) + dunes(pos) , 1.0);
}

vec2 castRay( in vec3 ro, in vec3 rd, in float maxd )
{
	float precis = 0.001;
    float h=precis*2.0;
    float t = 0.0;
    float m = -1.0;
    for( int i=0; i<60; i++ )
    {
        if( abs(h)<precis||t>maxd ) continue;//break;
        t += h;
	    vec2 res = map( ro+rd*t );
        h = res.x;
	    m = res.y;
    }

    if( t>maxd ) m=-1.0;
    return vec2( t, m );
}

float softshadow( in vec3 ro, in vec3 rd, in float mint, in float maxt, in float k )
{
	float res = 1.0;
    float t = mint;
    for( int i=0; i<30; i++ )
    {
		if( t<maxt )
		{
        float h = map( ro + rd*t ).x;
        res = min( res, k*h/t );
        t += 0.02;
		}
    }
    return clamp( res, 0.0, 1.0 );

}

vec3 calcNormal( in vec3 pos )
{
	vec3 eps = vec3( 0.001, 0.0, 0.0 );
	vec3 nor = vec3(
	    map(pos+eps.xyy).x - map(pos-eps.xyy).x,
	    map(pos+eps.yxy).x - map(pos-eps.yxy).x,
	    map(pos+eps.yyx).x - map(pos-eps.yyx).x );
	return normalize(nor);
}

float calcAO( in vec3 pos, in vec3 nor )
{
	float totao = 0.0;
    float sca = 1.0;
    for( int aoi=0; aoi<5; aoi++ )
    {
        float hr = 0.01 + 0.05*float(aoi);
        vec3 aopos =  nor * hr + pos;
        float dd = map( aopos ).x;
        totao += -(dd-hr)*sca;
        sca *= 0.75;
    }
    return clamp( 1.0 - 4.0*totao, 0.0, 1.0 );
}

vec3 render(in vec3 ro, in vec3 rd, in vec2 uv)
{
	vec3 col = sky(uv);
	vec2 res = castRay(ro, rd, 20.0);	
	float t = res.x;
	float m = res.y;
	if(m>-0.5)
	{
		vec3 pos = ro + t*rd;
        vec3 nor = calcNormal( pos );

		vec3 newcol = vec3(0.25, 0.22, 0.1) + getNoise(pos.xx*4., 1.0)*.7;
		
        float ao = calcAO( pos, nor );

		vec3 lig = normalize( vec3(-sin(iTime)*0.8, 0.8, -4.7) );
		float amb = clamp( 0.5+0.2*nor.y, 0.0, 1.0 );
        float dif = clamp( dot( nor, lig ), 0.0, 1.0 );
        float bac = clamp( dot( nor, normalize(vec3(-lig.x,0.0,-lig.z))), 0.0, 1.0 )*clamp( 1.0-pos.y,0.0,1.0);

		float sh = 1.0;
		if( dif>0.001 ) { sh = softshadow( pos, lig, 0.02, 10.0, 7.0 ); dif *= sh; }

		vec3 brdf = vec3(0.0);
		brdf += 0.20*amb*vec3(0.10,0.11,0.13)*ao;
        brdf += 0.20*bac*vec3(0.15,0.15,0.15)*ao;
        brdf += 1.20*dif*vec3(1.00,0.90,0.70);

		float pp = clamp( dot( reflect(rd,nor), lig ), 0.0, 0.2 );
		float spe = sh*pow(pp,32.0);
		float fre = ao*pow( clamp(1.0+dot(nor,rd),0.0,1.0), 2.0 );

		float fog = exp(-0.05 * res.x*res.x);
		newcol = newcol*brdf + vec3(1.0)*newcol*spe + 0.2*fre*(0.5+0.5*newcol) ;	
		col = mix(col, newcol, fog);
	}
	//col *= exp( -0.01*t*t );
	return clamp(col, 0.0, 1.0);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 q = gl_FragCoord.xy/iResolution.xy;
    vec2 p = -1.0+2.0*q;
	p.x *= iResolution.x/iResolution.y;
	vec3 ro = vec3( sin(iTime)*0.2, 0.05, 2.5 - iTime);
	vec3 ta = vec3( -0.0, -0.0, 0.0 - iTime);
	vec3 cw = normalize( ta-ro );
	vec3 cp = vec3( 0.0, 1.0, 0.0 );
	vec3 cu = normalize( cross(cw,cp) );
	vec3 cv = normalize( cross(cu,cw) );
	vec3 rd = normalize( p.x*cu + p.y*cv + 2.5*cw );

	
    vec3 col = render( ro, rd, p );
	
	col = sqrt( col );

    gl_FragColor=vec4( col, 1.0 );
}