#version 120

uniform sampler2D texture0;
uniform sampler2D texture1;

vec4 vTexCoord = gl_TexCoord[0];
uniform vec2 textureSize0;
uniform float u_Elapsed;
vec2 Offset = vec2(1.0) / textureSize0;
vec3 outp;
float x;
float y;
float mulr = 0.0;
float mulg = 0.0;
vec3 col;
vec3 LC = vec3(0.2126, 0.7152, 0.0722);//correct


float GetLuma(vec3 rgb) {
    return dot(LC, rgb);
}

vec4 BG = texture2D(texture1, vTexCoord.xy);

void main(void)
{


  	vec4 Girl = texture2D(texture0, vTexCoord.xy);
  	float g = GetLuma(Girl.rgb);


  	for (x=1.0; x<50.0; x+=1.0)
  	{
  		vec4 Gr = texture2D(texture0, vTexCoord.xy + Offset * vec2 ( x, 0.0) );
  		vec4 Gl = texture2D(texture0, vTexCoord.xy + Offset * vec2 (-x, 0.0) );

  		if (Gr.a != 1.0 || Gl.a != 1.0)
  		{
  			break;
  		}
  		col.r += (g-GetLuma(Gr.rgb) )/x;
  		mulr += 1.0/x;
  	}


  	for (y=1.0; y<50.0; y+=1.0)
  	{
  		vec4 Gd = texture2D(texture0, vTexCoord.xy + Offset * vec2 ( 0.0, y) );
  		vec4 Gu = texture2D(texture0, vTexCoord.xy + Offset * vec2 ( 0.0,-y) );
  		if (Gd.a != 1.0 || Gu.a != 1.0)
  		{
  			break;
  		}
  		col.g += ( g-GetLuma(Gd.rgb) )/y;
  		mulg += 1.0/y;
  	}


  	col.b = g;
  	col.r = col.r/mulr;
  	col.g = col.g/mulg;
  	//col.rg = (col.rg+1.0)*0.5;


float mul1 = 1530.0*BG.r;
float mul2 = 1560.0*BG.g;
float mul3 = 1590.0*BG.b;



outp.r = texture2D(texture1, vTexCoord.xy + Offset * vec2 ( col.r*mul1, col.g*mul1) ).r;
outp.g = texture2D(texture1, vTexCoord.xy + Offset * vec2 ( col.r*mul2, col.g*mul2) ).g;
outp.b = texture2D(texture1, vTexCoord.xy + Offset * vec2 ( col.r*mul3, col.g*mul3) ).b;


outp.rgb = mix(Girl.rgb, outp.rgb,  smoothstep(0.50, 0.51, col.b+(sin(u_Elapsed*0.5))  ) );

gl_FragColor = vec4( outp.rgb, Girl.a);


}
