#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Distorted sdfMod01.fsh   by   franco1234811    
//https://www.shadertoy.com/view/lX2yzG
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define TRIANGLE_COUNT 15.0f
#define TWO_PI 6.28318530718

float sdEquilateralTriangle( in vec2 p, in float r )
{
    const float k = sqrt(3.0);
    p.x = abs(p.x) - r;
    p.y = p.y + r/k;
    if( p.x+k*p.y>0.0 ) p = vec2(p.x-k*p.y,-k*p.x-p.y)/2.0;
    p.x -= clamp( p.x, -2.0*r, 0.0 );
    return -length(p)*sign(p.y);
}

mat2 create_rotation_matrix(float angle)
{
    float c_a = cos(angle);
    float s_a = sin(angle);
    return mat2(
        vec2(c_a, -s_a),
        vec2(s_a, c_a));
}

vec3 sampleColor(float t)
{
    return vec3(
        sin(t * TWO_PI + 0.25f) * 0.5f + 0.5f,
        sin(t * TWO_PI + 1.5f) * 0.5f + 0.5f,
        sin(t * TWO_PI + 2.5f) * 0.5f + 0.5f);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy;
    vec2 centered_uv = 2.0f * uv - vec2(1.0f);
    float aspect_ratio = iResolution.x / iResolution.y;
    centered_uv.y /= aspect_ratio;
    
    // Parameter used to loop the animation
    float loop_t = 0.5f + 0.5f * abs(sin(iTime) * 0.5f + 0.5f);
    
    float triangle_sd = sdEquilateralTriangle(centered_uv, loop_t * 0.55f);
    
    // Creates rotation matrix with the signed distance of the centered triangle
    mat2 rotation = create_rotation_matrix(iTime + 3.0f * triangle_sd);
    
    float rotated_triangle = mix(
        sdEquilateralTriangle(rotation * centered_uv, loop_t * 0.75f), 
        length(centered_uv),
        abs(sin(iTime) * 0.5f + 0.5f) * 0.5f);
    
    // Time changing color t
    float color_sample_t = iTime * 0.1f + rotated_triangle;
    
    // Samples base color
    vec3 color_a = sampleColor(color_sample_t);
    
    // Calculates bright color with brightness
    float brightness = (1.0f - length(centered_uv)) * 5.0f;
    vec3 bright_color = color_a * brightness;
    float t = smoothstep(0.10, 0.15f, fract(rotated_triangle * TRIANGLE_COUNT));
    // Output to screen
    fragColor = vec4(mix(bright_color, color_a, t), 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

