#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Mobius SierpinskiMod01.fsh   by  Shane   
//https://www.shadertoy.com/view/XsGXDV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*

	Mobius Sierpinski
	-----------------

	Applying a Mobius transform and spiral zoom to a Sierpinski Carpet pattern.


	Related examples:

	// Nice and simple.
	SierpinskiCarpet - jt
	https://www.shadertoy.com/view/ldc3WH
	
	Mobius Eggs - Shane
	https://www.shadertoy.com/view/ldVXDG

*/

// Standard Mobius transform: f(z) = (az + b)/(cz + d). Slightly obfuscated.
vec2 Mobius(vec2 p, vec2 z1, vec2 z2){

	z1 = p - z1; p -= z2;
	return vec2(dot(z1, p), z1.y*p.x - z1.x*p.y)/dot(p, p);
}

// Standard spiral zoom.
vec2 spiralZoom(vec2 p, vec2 offs, float n, float spiral, float zoom, vec2 phase){
	
	p -= offs;
	float a = atan(p.y, p.x)/6.283 - iTime*.25;
	float d = log(length(p));
	return vec2(a*n + d*spiral, a - d*zoom) + phase;
}

// Mobius, spiral zoomed, Sierpinski Carpet pattern.
vec3 pattern(vec2 uv){
    
    // A subtlely spot-lit background. Performed on uv prior to tranformation,
    float bg = max(1. - length(uv), 0.)*.025; 
    
    // Transform the screen coordinates. Comment out the following two lines and 
    // you'll be left with a standard Sierpinski pattern.
    uv = Mobius(uv, vec2(-.75, cos(iTime)*.25), vec2(.5, sin(iTime)*.25));
    uv = spiralZoom(uv, vec2(-.5), 5., 3.14159*.2, .5, vec2(-1, 1)*iTime*.25);
    
     
    vec3 col = vec3(bg); // Set the canvas to the background.
    
    // Sierpinski Carpet - Essentially, space is divided into 3 each iteration, and a 
    // shape of some kind is rendered. In this case, it's a smooth rectangle
    // with a bit of shading around the side.
    //
    // There's some extra steps in there (the "l" and "mod" bits) due to the 
    // shading and coloring, but it's pretty simple.
    //
    // By the way, there are other combinations you could use.
    //
    for(float i=0.; i<4.; i++){
        
        uv = fract(uv)*3.; // Subdividing space.
        
        vec2 w = .5 - abs(uv - 1.5); // Prepare to make a square. Other shapes are also possible.
        
        float l = sqrt(max(16.0*w.x*w.y*(1.0-w.x)*(1.0-w.y), 0.)); // Vignetting (edge shading).
        
        w = smoothstep(0., length(fwidth(w)), w); // Smooth edge stepping.
        
        vec3 lCol = vec3(1)*w.x*w.y*l; // White shaded square with smooth edges.
        
        if(mod(i, 3.)<.5) lCol *= vec3(0.1, 0.8, 1); // Color layers zero and three blue.
        
        col = max(col, lCol); // Taking the max of the four layers.
        
    } 
    
    return col;
    
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ // my attempt to code-golf it (137chars)

    // Screen coordinates.
    vec2 uv = (fragCoord - iResolution.xy*.5)/iResolution.y;
    
    // Transformed Sierpinski pattern.
    vec3 col = pattern(uv);
    
    // Rough gamma correction.
    fragColor = vec4(sqrt(col), 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

