#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// basic planets v1Mod01.fsh  by  jorge2017a2
//https://www.shadertoy.com/view/ftXfW8
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//----------image
//por jorge2017a2-
#define MAX_STEPS 100
#define MAX_DIST 400.
#define MIN_DIST 0.001
#define EPSILON 0.001
//referencia
// "field of stars" by ändrom3da
//https://glslsandbox.com/e#80574.18
vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material);
vec3 getMaterial( vec3 pp, float id_material);
vec3 light_pos1;  vec3 light_color1 ;
vec3 light_pos2;  vec3 light_color2 ;

//operacion de Union  por FabriceNeyret2
#define opU2(d1, d2) ( d1.x < d2.x ? d1 : d2 )
///------------
vec3 ti = vec3(0.0, 0.0, 0.0);  // tile index

#define RANDOMFACTOR_STARS 0.99825
#define SPEED 1.0

///#define TILE_DISTANCE 2.0
#define TILE_DISTANCE 20.0

#define TILE_ATTENTUATION 0.
//#define STAR_INTENSITY 1.
#define STAR_SIZE 1.00

#define HASH	p = fract(p * .1031); p *= p + 3.3456; return fract(p * (p + p));

//-------common
#define PI 3.14159265


///Gracias a Shane...16-jun-2020
vec3 tex3D( sampler2D tex, in vec3 p, in vec3 n ){    
  n = max(n*n - .2, .001); // max(abs(n), 0.001), etc.
  n /= dot(n, vec3(1)); 
  vec3 tx = texture2D(tex, p.yz).xyz;
  vec3 ty = texture2D(tex, p.zx).xyz;
  vec3 tz = texture2D(tex, p.xy).xyz;
  return mat3(tx*tx, ty*ty, tz*tz)*n; 
}
//------end common

vec4 h44(vec4 p) { HASH }
//---------------
float sdSphere( vec3 p, float s )
	{ return length(p)-s;}

vec3 N33(vec3 p) {
    vec3 a = fract(p/9999.99*vec3(1293.34,2389.34,3949.65));
    a+=dot(a,a+99.99);
    return fract(vec3(a.x*a.y*2.22,a.y*a.z,a.z*a.x));
}

mat2 Rot(float a) {
    float s=sin(a), c=cos(a);
    return mat2(c, -s, s, c);
}

vec3 opRepTI(vec3 p, vec3 r)
{	ti= floor(((p/2.0) + r*0.5)/r);  // tile index global variable
	return mod(p + r,2.0 * r) - r;	
}

vec2 GetDist(vec3 p  ) 
{	vec2 res= vec2(9999.0, -1.0);  vec3 p0=p;
    vec3 r = opRepTI(p, vec3(TILE_DISTANCE));
    float boxes;
	if (N33(ti).x*1.1 > RANDOMFACTOR_STARS)
    {  boxes = sdSphere(r + TILE_ATTENTUATION*N33(ti), 6.0);
       res =opU2(res, vec2(boxes,100.0));
	}
    else
	{   boxes = sdSphere(r,0.0);
        res =opU2(res, vec2(boxes,0.0));
	}
    return res;
}

vec3 GetNormal(vec3 p)
{   float d = GetDist(p).x;
    vec2 e = vec2(.001, 0);
    vec3 n = d - vec3(GetDist(p-e.xyy).x,GetDist(p-e.yxy).x,GetDist(p-e.yyx).x);
    return normalize(n);
}

vec2 RayMarch(vec3 ro, vec3 rd, int PMaxSteps)
{   vec3 p;
    vec2 hit, object=vec2(0.1,0.0);
   for(int i=0; i <= PMaxSteps; i++) 
    { p = ro + rd*object.x;
      hit = GetDist(p);
      object.x += hit.x;
      object.y = hit.y;
      if (abs(hit.x) < EPSILON || object.x > MAX_DIST) break;
    }
    return object;
}

float getSoftShadow(vec3 p, vec3 lightPos) {
    float res = 9999.0;
    float dist = 0.01;
    float lightSize = 0.03;
    for (int i = 0; i < MAX_STEPS; i++) {
      float hit = GetDist(p + lightPos * dist).x;
      res = min(res, hit / (dist * lightSize));
      dist += hit;
      if (hit < 0.0001 || dist > 60.0) break;
    }
    return clamp(res, 0.0, 1.0);
}

float occlusion(vec3 pos, vec3 nor)
{   float sca = 2.0, occ = 0.0;
    for(int i = 0; i < 10; i++) {    
      float hr = 0.01 + float(i) * 0.5 / 4.0;
      float dd = GetDist(nor * hr + pos).x;
      occ += (hr - dd)*sca;
      sca *= 0.6;
    }
    return clamp( 1.0 - occ, 0.0, 1.0 );    
}

vec3 lightingv3(vec3 normal,vec3 p, vec3 lp, vec3 rd, vec3 ro,vec3 lightColor, float t) 
{   vec3 lightPos=lp;
    vec3 worldPos = ro + rd * t;
    vec3 V = -rd;
    vec3 N = GetNormal(worldPos);
    vec3 L = normalize (lightPos - worldPos);
    vec3 R = reflect (-L, N);

    float lightDist = max(length(L), .001);
    float atten=1.0 / (1.0 + lightDist * 0.125 + lightDist * lightDist * .05);
    L /= (lightDist*atten);

    float shadow = getSoftShadow(worldPos, normalize(lightPos));// shadows
    float occ = occlusion(worldPos, N);// occ
    vec3 ambient= 0.5*lightColor*clamp(0.5 + 0.5*N.y, 0.0, 1.0)*N.y;
    vec3 fresnel =  lightColor *  pow(clamp(1.0 + dot(rd, N), 0.0, 1.0), 2.0);;
    float diff       = clamp(dot(N, L), 0.0, 1.0);

    diff = pow(diff, 4.) * 2.;
    vec3 diffuse =  lightColor * diff;
    float shininess=8.0;
    float specular    = pow(max(dot(R, V), 0.0), shininess);
    
    vec3 back = 0.5 * lightColor * clamp(dot(N, -L), 0.0, 1.0); // back
    vec3 colOut = occ*lightColor*(ambient+diffuse*shadow+.35 +back) + vec3(.7,.9,1)*specular*specular;
    return colOut;
}

vec3 getColorTextura( vec3 p, vec3 nor,  int i)
{	if (i==100 )
    { vec3 col=tex3D(texture0, p/32., nor); return col+0.2; }
	if (i==101 ) { return tex3D(texture1, p/32., nor); }
	if (i==102 ) { return tex3D(texture2, p/32., nor); }
	if (i==103 ) { return tex3D(texture3, p/32., nor); }
}

vec3 render_sky_color(vec3 rd)
{   float t = (rd.x + 1.0) / 2.0;
    vec3 col= vec3((1.0 - t) + t * 0.3, (1.0 - t) + t * 0.5, (1.0 - t) + t);
    vec3  sky = mix(vec3(.0, .1, .4)*col, vec3(.3, .6, .8), 1.0 - rd.y);
	return sky;
}

vec3 GetMaterial(vec3 p,  vec3 nor, vec3 ro,  vec3 rd, int id_color)
{  	vec3 colobj; 
     if (id_color==0) { colobj=vec3(0.0);  return colobj; }
     if (id_color==1) { colobj=vec3(1.0);  return colobj; }
    
   if (id_color==100 )
   { return  getColorTextura( p, nor,100); }
        
}

vec3 linear2srgb(vec3 c) 
{ return mix(12.92 * c,1.055 * pow(c, vec3(1.0/1.8)) - 0.055, step(vec3(0.0031308), c)); }

vec3 exposureToneMapping(float exposure, vec3 hdrColor) 
{ return vec3(1.0) - exp(-hdrColor * exposure); }

vec3 ACESFilm(vec3 x)
{   float a,b,c,d,e;
    a = 2.51; b = 0.03; c = 2.43;d = 0.59; e = 0.14;
    return (x*(a*x+b))/(x*(c*x+d)+e);
}

vec3 Render(vec3 ro, vec3 rd)
{  vec3 col = vec3(0);
  vec3 p;
     vec2 hit=RayMarch(ro,rd, MAX_STEPS);
      if(hit.x<MAX_DIST) 
       {   p = (ro + rd * hit.x );  
        vec3 nor=GetNormal(p);
        
        vec3 colobj;
        colobj=GetMaterial( p, nor, ro, rd,  int(hit.y));        
        vec3 result;
         result= lightingv3(nor, p,light_pos1,rd,ro,colobj,hit.x)*light_color1;
        result+= lightingv3(nor, p,light_pos2,rd, ro,colobj,hit.x)*light_color2;
        col= result/2.0;
        col= (ACESFilm(col)+linear2srgb(col)+col+ exposureToneMapping(3.0, col))/4.0 ;        
    }
    
    float fog = 1.0 - pow(128./hit.x, 0.80)*1.5;
    if (hit.x > MAX_DIST) col = vec3(0.0, 0.0, 0.0);
        
   return col;
}

vec3 GetRayDir(vec2 uv, vec3 p, vec3 l, float z) 
{
    vec3 f = normalize(l-p),
        r = normalize(cross(vec3(0,1,0), f)),
        u = cross(f,r),
        c = f*z,
        i = c + uv.x*r + uv.y*u,
        d = normalize(i);
    return d;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
    float t;
    t=iTime*60.0;
 	light_pos1= vec3(10., 10.0, 25.0 ); light_color1=vec3( 1.0,1.0,1.0 );
 	light_pos2= vec3(-10., 10.0, -25.0 ); light_color2 =vec3( 1.0,1.0,1.0 ); 
 
     vec3 ro = vec3(0.,10., 0.+t);
   vec3 rd=normalize( vec3(uv.x,uv.y,1.0));
    //light_pos1-=ro;
    //light_pos2-=ro;
    vec3 col= Render( ro,  rd);
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

