#version 330
#extension GL_ARB_compatibility : enable
#extension GL_ARB_fragment_coord_conventions : enable
//antiAliasRGBA.fsh
uniform sampler2D texture0;
uniform vec2 textureSize0;
varying vec4 gl_TexCoord[];
//
void main( void ) {
	vec4 texCoords = gl_TexCoord[0];
////////////////////////////////////////////////////////
	vec4 RGBA0 = texture2D(texture0).rgba; // color and alpha of Texture0
	vec3 RGB0 = texture2D(texture0).rgb; // color only of Texture0
	float A0 = texture2D(texture0).a; // alpha only of Texture0
////////////////////////////////////////////////////////
//	
//
    float FXAA_SPAN_MAX = 8.0;
    float FXAA_REDUCE_MUL = 1.0/8.0;
    float FXAA_REDUCE_MIN = 1.0/128.0;
//
//
    vec4 rgbNW=texture2D(texture0,texCoords.xy+(vec2(-1.0,-1.0)/textureSize0)).rgba;
    vec4 rgbNE=texture2D(texture0,texCoords.xy+(vec2(1.0,-1.0)/textureSize0)).rgba;
    vec4 rgbSW=texture2D(texture0,texCoords.xy+(vec2(-1.0,1.0)/textureSize0)).rgba;
    vec4 rgbSE=texture2D(texture0,texCoords.xy+(vec2(1.0,1.0)/textureSize0)).rgba;
    vec4 rgbM=texture2D(texture0,texCoords.xy).rgba;
//
    vec4 luma=vec4(0.299, 0.587, 0.114, 0.8);
    float lumaNW = dot(rgbNW, luma);
    float lumaNE = dot(rgbNE, luma);
    float lumaSW = dot(rgbSW, luma);
    float lumaSE = dot(rgbSE, luma);
    float lumaM  = dot(rgbM,  luma);
//
    float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
    float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));
//
    vec2 dir;
    dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));
    dir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));
//
    float dirReduce = max(
        (lumaNW + lumaNE + lumaSW + lumaSE) * (0.25 * FXAA_REDUCE_MUL),
        FXAA_REDUCE_MIN);
//
    float rcpDirMin = 1.0/(min(abs(dir.x), abs(dir.y)) + dirReduce);
//
    dir = min(vec2( FXAA_SPAN_MAX,  FXAA_SPAN_MAX),
          max(vec2(-FXAA_SPAN_MAX, -FXAA_SPAN_MAX),
          dir * rcpDirMin)) / textureSize0;
//
    vec4 rgbA = (1.0/2.0) * (
        texture2D(texture0, texCoords.xy + dir * (1.0/3.0 - 0.5)).rgba +
        texture2D(texture0, texCoords.xy + dir * (2.0/3.0 - 0.5)).rgba);
    vec4 rgbB = rgbA * (1.0/2.0) + (1.0/4.0) * (
        texture2D(texture0, texCoords.xy + dir * (0.0/3.0 - 0.5)).rgba +
        texture2D(texture0, texCoords.xy + dir * (3.0/3.0 - 0.5)).rgba);
    float lumaB = dot(rgbB, luma);

    if((lumaB < lumaMin) || (lumaB > lumaMax)){
        gl_FragColor = rgbA;
    }else{
        gl_FragColor = rgbB;
    }
/////////////////////////////////////////////////////
// use the new variable in place of gl_TexCoord[0].rgba	
        gl_FragColor *= RGBA0;
    
}