

// Coordonnees de texture et couleur pour le fragment
//
//
// additions by WyldAnimal
// some custom variables to play with..
// define some variable to use in the formulas
// you can make up your own variable names to use...
//
#define Xoffset 20.0
#define Xmultiplier 30.0
#define Yoffset 10.0
#define Ymultiplier 10.0

// only leave one of these not commented.
// it will control which set of formulas is used.
#define UseSine 
//#define UseCosine 
//#define UseBoth 
//#define UseTangent  // use smaller values above with Tan


varying vec4 gl_TexCoord[5];
varying vec4 gl_FrontColor;
 
uniform float u_Elapsed;

void main()
{
    vec4 displacedVertex;
    displacedVertex = gl_Vertex;

    float len = length( displacedVertex );
	
// inserted the custom variables in the formulas
// and added tests to determine what set of formulas to use

// test if UseSine is not commented ( it's Defined )
// if it is, then uses these formulas
#ifdef UseSine 
    displacedVertex.x += Xoffset * sin( u_Elapsed + len *Xmultiplier);
    displacedVertex.y += Yoffset * sin( u_Elapsed + len *Ymultiplier);
#endif

// test if UseCosine is not commented ( it's Defined )
// if it is, then uses these formulas
#ifdef UseCosine
    displacedVertex.x += Xoffset * cos( u_Elapsed * len *Xmultiplier);
    displacedVertex.y += Yoffset * cos( u_Elapsed + len *Ymultiplier);
#endif

// test if UseBoth is not commented ( it's Defined )
// if it is, then uses these formulas
#ifdef UseBoth
    displacedVertex.x += Xoffset * sin( u_Elapsed * len *Xmultiplier);
    displacedVertex.y += Yoffset * cos( u_Elapsed + len *Ymultiplier);
#endif	

// test if UseTangent is not commented ( it's Defined )
// if it is, then uses these formulas	
#ifdef UseTangent
    displacedVertex.x += Xoffset * tan( u_Elapsed * len *Xmultiplier);
    displacedVertex.y += Yoffset * tan( u_Elapsed + len *Ymultiplier);
#endif	

	
	
    // Position sur l'ecran
    gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * displacedVertex;


    // Position dans la texture
    gl_TexCoord[0] = gl_MultiTexCoord0;

    gl_FrontColor = gl_Color;

    

}




