// Fractal Plasma by WyldAnimal
// adapted from a shader at Shadertoy.com
// 
//
// Totem uses a different set of variables
uniform float u_Elapsed; // Replace all iGlobalTime with u_Elapsed
uniform vec2 u_WindowSize; // Replace all iResolution with u_WindowSize
uniform sampler2D texture0; // Replace all iChannel0 with Texture0 

// change these to control the plasma
// all of these must be a decimal value - except where noted
// change one thing at a time...
#define lines				0.00001 	// 0.1 to .00001 line thickness
#define complexity			17		// No Decimal, how complex is the fractal 3 to 100, no decimal.
#define power				2.1		// 0.1 to 10.0 smaller means stronger changes	
#define speed				0.01	// speed of color change 0.01 to 10.0
#define outspeed			.001 	// how fast the zoom away take place .1 to .001
#define zoommag				50.01 	// zoom multiplier 1.01 to 500.01
#define plasmax				0.07545465789 // randomize seed Positive <.01
#define plasmay				-0.06123356987 // randomize seed Negative < -.01
#define ceey				1.1		// rotation speed y .01 to 10.0
#define grainsize			4.0		// blend amount of adjacent color 0.1 to 10.0

// these are the Orig Values. In case you need to reset them
// Don't change these. Change the ones above.
//#define lines			0.00001 
//#define complexity	17
//#define power			2.1	
//#define speed			0.01
//#define outspeed		.001
//#define zoommag		50.01
//#define plasmax		0.07545465789
//#define plasmay		-0.06123356987
//#define ceey			1.1
//#define grainsize		4.0	

vec3 hsv(in float h, in float s, in float v)
{
	return mix(vec3(1.0), clamp((abs(fract(h + vec3(3, 2, 1) / 3.0) * 6.0 - 3.0) - 1.0), 0.23 , 1.3), s) * v;
}

vec3 formula(in vec2 p, in vec2 c)
{
	const float n = power;
	const int iters = complexity;

	float time = u_Elapsed*speed;
	vec3 col = vec3(0);
	float t = 1.0;
	float dpp = dot(p, p);
	float lp = sqrt(dpp);
	float r = smoothstep(0.0, 0.2, lp);
	
	for (int i = 0; i < iters; i++) {
		// The transformation
		p = abs(mod(p/dpp + c, n) - n/2.0);
		
		dpp = dot(p, p);
		lp = sqrt(dpp);

		//Shade the lines of symmetry black
#if 0
		// Get constant width lines with fwidth()
		float nd = fwidth(dpp);
		float md = fwidth(lp);
		t *= smoothstep(0.0, 0.5, abs((n/2.0-p.x)/nd*n))
		   * smoothstep(0.0, 0.5, abs((n/2.0-p.y)/nd*n))
		   * smoothstep(0.0, 0.5, abs(p.x/md))
		   * smoothstep(0.0, 0.5, abs(p.y/md));
#else
		// Variable width lines - Modified to eliminate the lines

		t *= smoothstep(0.0, lines, abs(n/2.0-p.x)*lp)
		   * smoothstep(0.0, lines, abs(n/2.0-p.y)*lp)
		   * smoothstep(0.0, lines, abs(p.x)*2.0) 
		   * smoothstep(0.0, lines, abs(p.y)*2.0);
#endif

		// Fade out the high density areas, they just look like noise
		r *= smoothstep(0.0, 0.2, lp);
		
		// Add to colour using hsv
		col += hsv(1.0 - max(p.x, p.y) + t*2.0 + time, 2.0-lp+t, r);
		
	}
	
	return (-cos(col/4.0)*0.5 + 0.5)*(t);
}

void main() {
	vec2 p = -1.0 + 2.0 * gl_FragCoord.xy / u_WindowSize.xy;
	p.x *= u_WindowSize.x / u_WindowSize.y;
	p *= zoommag * (fract(u_Elapsed * outspeed) + 0.001);
	const vec2 e = vec2(plasmax, plasmay);
	vec2 c = u_Elapsed*e * (1.3, ceey);
	float d = 1.0;
	vec3 col = vec3(0.0);
	const float blursamples = grainsize; 
	float sbs = sqrt(blursamples);
	float mbluramount = 1.0/u_WindowSize.x/length(e)/blursamples*2.0;
	float aabluramount = 1.0/u_WindowSize.x/sbs*4.0;
	for (float b = 0.0; b < blursamples; b++) {
		col += formula(
			p + vec2(mod(b, sbs)*aabluramount, b/sbs*aabluramount), 
			c + e*mbluramount*b);
	}
	col /= blursamples;
	gl_FragColor = vec4(col, 1.0);
}