// Colors by WyldAnimal
// 
//
// Totem uses a different set of variables
uniform float u_Elapsed; // Replace all iGlobalTime with u_Elapsed
uniform vec2 u_WindowSize; // Replace all iResolution with u_WindowSize
uniform sampler2D texture0; // Replace all iChannel0 with Texture0 

// a Fragment is the area taken up by the vertices. 
// Three vertices create a fragment in the shape of a triangle. 
// a fragment shader, fills in the color in the area created by the vertexes.
// 3 vertexes create a triangle and Two triangles create a Quad.
// These fragments are made up of two triangles, combined together to form a Quad
// The Quad is the size of our view port, Usually the whole screen
// so we are filling in the color of every pixel in the Quad that is Our View port.
// for every pixel in the fragment. a calculation is made.
// the results of that calculation determines the color of that Pixel.
// how many Frames per second, depends on the time it takes to perform the calculations.
// These are done in the GPU. so it all depends on the Speed of the GPU 

// gl_FragCoord is a vec4 value that is built in.
// gl_FragCoord.x is the X coord of the Pixel.
// gl_FragCoord.y is the Y coord of the Pixel.
// gl_FragCoord.z is the Z value of the Pixel.
// gl_FragCoord.w is the forth float of the vec4 value
// for this shader, only the X and Y values are used in the calculations.
// anything seen on the screen is all based on a procedural calculation.
// for every pixel x, y  we make a calculation.
// based on that calculation a color value is assigned to that pixel.
// the entire frame is calculated in a frame buffer
// it is then displayed on Screen all at once.
// then the whole loop is calculated into the frame buffer again, and then Displayed.

// start of one frame
void main() { // this is the start of the loop For Every Pixel on the Fragment 
			  // the same calculation is applied to Every pixel.
// here we define a variable called 'col' that consists of 3 floats
// vec3 means it will be 3 floats. 'col' is the name of the variable.
// col will be used to hold our 3 Color components 
// a blend of 3 Floats in the order of R G B
// 0.0 = off and 1.0 = full saturation

vec3 col = vec3(  // now calculate Red, Green, blue values

// we need 3 floats. one for Red, One for Green, One for Blue

// calculate the Red Value based on the X and Y pixel coords.
// by Negating the Subtraction of Y from X the reds will lean to the right
// to make it Lean to the left, Add them
// to change how much it leans, alter the multiplier value.
// the use of the Time will increase the number of red sine waves.
// this is the RED value there is a comma after the value.
//col.r
sin((fract(-(gl_FragCoord.x - 2.0 * gl_FragCoord.y ) * (u_Elapsed*10.0)/50000.0))*6.28 ) ,
// break down the formula in to each part
// time based multiplier
// this will be a slow change over time. for faster changes 50000 = 5000
//  * (u_Elapsed*10.0)/50000.0)
// the incoming Pixel coords  are used in a formula.
// negate (X - (2.0 * Y))
//-(gl_FragCoord.x - 2.0 * gl_FragCoord.y )
// the results of the calculation are larger than 1.
// we want a value Less than 1.
// this drops the whole number and Keeps just the Fractional remainder.
//
//fract(-(gl_FragCoord.x - 2.0 * gl_FragCoord.y ) * (u_Elapsed*10.0)/50000.0)
//
// now we have a fractional value less than 1.
// all Trig functions are based on radians. 2 * pi radians in a full 360 degrees.
// 2 * pi is  is 2 * 3.14159265 or 6.28 approx..
// so we take the fractional value and multiply it times 6.28
// then we use the Sin of that value as the amount of RED for that Pixel.
//sin((fract(-(gl_FragCoord.x - 2.0 * gl_FragCoord.y ) * (u_Elapsed*10.0)/50000.0))*6.28 ) ,
// and we need the Comma after it, because it is the First of our Three Floats.
// it is the R value of our variable 'col'
// I won't break down the other formulas for the Green and Blue values.
// using the Above notes, you should be able to break down the next to on your own.


// calculate the Green Value Based on the X and Y pixel Coords.
// By Adding Y and X, the Greens will lean to the left. 
// because it is addition it doesn't mater if we add X+Y or Y+X
// the results of the addition would be the same.
// to change how much it leans, alter the multiplier value.
// the use of the Time will increase the number of green sine waves.
//This is the Green Value there is a comma after the value.
// col.g
sin(((fract((gl_FragCoord.y + 1.0 * gl_FragCoord.x ) * (u_Elapsed*30.0)/70000.0))+ .02)*6.28) ,

// calculate the Blue Value Based on the Y pixel Coords.
// By using just Y, the blues will be a horizontal band. 
// the use of the Time will increase the number of blue cos waves.
// This is the Blue Value. It's the Last float so no Comma.
//col.b
cos((fract(gl_FragCoord.y * (u_Elapsed*10.0)/90000.0))*6.28 ) 
); // this is the end of the vec3 

// add the calculated 'col' to the frame buffer
// this means the same
// gl_FragColor = vec4(col, 1.0); 
// as this
	gl_FragColor = vec4(col.r, col.g, col.b, 1.0); 
	// the , 1.0 is the Alpha Channel. 1.0 = full opacity.
} // end of the loop, 
//repeat for every single Pixel as fast as you can.
// display the entire frame when every pixel has been calculated.