#version 330
#extension GL_EXT_gpu_shader4 : enable
// VoronoiGoofMod01.fsh  by  Taron 

//https://www.shadertoy.com/view/WtXXWS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 N22(vec2 p)
{
    vec3 a = fract(p.xyx*vec3(123.34, 234.45, 345.65));
    a += dot(a, a+34.45);
    return fract(vec2(a.x*a.y, a.y*a.z));
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (2.*gl_FragCoord.xy-iResolution.xy)/iResolution.y;
    float m = 0.;
    float t = iTime*2.5;
    
    float minDist = 100.;
    float cellIndex = 0.;
    vec2 cid = vec2(0);
    
    vec3 col = vec3(1.);
    vec3 norm = vec3(0.,0.,-1.);
    
    vec3 pos = vec3(uv,0.);

    uv *= 6.+sin(t*.25)*4.;
    vec2 gv = fract(uv)-.5;
    vec2 id = floor(uv);
    for(float y=-1.; y<=1.; y++)
        for(float x=-1.; x<=1.; x++)
        {
            vec2 offs = vec2(x,y);

            vec2 n = N22(id+offs);
            vec2 p = offs+sin(n*t)*0.5;

            p -= gv;

            
            float toff = t+p.x+id.y+offs.y;
            vec2 rps = vec2(sin(toff), cos(toff));
            vec2 rp = vec2(p.x*rps.x+p.y*rps.y,p.x*rps.y-p.y*rps.x); 
            
            float d = length(p);
            
            d = mix(d, abs(rp.x)+abs(rp.y),sin(t*0.5));
            

            if(d<minDist)
            {  
                norm.rg = p;
                norm.b = .75-d;
                minDist = d;
                cid = vec2(5.)+id+offs;
            }
        }

    float v = (0.75-minDist*0.5);
    col *= vec3(v);
    col *= 0.25+0.75*N22(cid).rgg;

    norm = normalize(norm);
    t*=0.35;
    vec3 lpos = vec3(4.*sin(t),4.*cos(t),0.);
    vec3 light = vec3(uv.xy-lpos.xy,lpos.z);
    
    float fancy = length(light)*.1;
    float ldist = 1.-min(1.,fancy);
    
    light = normalize(light);
    float ss = max(0.,0.5+0.5*dot(light, norm));
    col *= 0.25+0.75*max(0.,dot(light, norm))+ss*vec3(0.7,.4,.3);
    col.gb *=vec2(ldist,ldist*ldist);
    vec3 rd = -normalize(vec3(pos.xy,0.85));
    col += 0.5*pow(max(0.,dot(reflect(rd, norm), light)),43.);
    col *= ldist * exp(1.-minDist);
    fancy = min(1., minDist*fancy*.5);
    col += fancy*fancy*vec3(0.,0.6,0.8);
    gl_FragColor = vec4(col,1.0);
}