// parent at http://glslsandbox.com/e#72202.0
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
//#define iGlobalTime u_Elapsed* 0.3141592
//90 FOV
//#define FOCAL_LENGTH 1.0 
#define time u_Elapsed*0.3141592
#define resolution u_WindowSize
//
//#define mouse vec4(0.0,0.0,0.0,0.0)
#define mouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )



#ifdef GL_ES
precision mediump float;
#endif

// glslsandbox uniforms
//uniform float time;
//uniform vec2 resolution;

// shadertoy emulation
#define iTime time
#define iResolution resolution


mat2 rotate2D (float rad)
{
    float c = cos (rad);
    float s = sin (rad);
    return mat2 (c, s, -s, c);
}


void yonatansFractal (float t, vec2 FC, vec2 r, inout vec3 o)
{
    float g=0., e, s, k = t*.1;
    for(float i=0.; i < 59.;++i) {
        vec3 p = vec3(g*(FC.xy - .5*r)/r.y + .5,g - 1.);
        p.xz *= rotate2D(k);
        s = 3.;
        for(int i=0; i < 4; ++i ) {
            s *= e = max(1.,(11.-2.*cos(k))/dot(p,p));
            p = vec3(2,4,2) - abs(abs(p)*e - vec3(4,4,2) );
        }
        g += min(length(p.xz), p.y)/s;
        o.rg += (s/5. + .5, 11.3, s/1e5);
    }
}

void main(void)
{
    float t = iTime + 20.;   // offset the time thus the thumbnail looks not empty
    vec2 FC = gl_FragCoord.xy;     // pixel-coordinates
    vec3 o = vec3 (.0);      // rgb-output color
    vec2 r = iResolution.xy; // resolution for point/ray-generation

    yonatansFractal(t, FC, r, o);

    gl_FragColor = vec4(o, 1.);
    gl_FragColor.a = length(gl_FragColor.rgb);
}

