// Sandbox72390_2.fsh
//http://glslsandbox.com/e#72390.2
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
//#define iGlobalTime u_Elapsed* 0.3141592
//90 FOV
//#define FOCAL_LENGTH 1.0 
#define time u_Elapsed*0.3141592
#define resolution u_WindowSize
//
#define mouse vec4(0.0,0.0,0.0,0.0)
#ifdef GL_ES
precision mediump float;
#endif

// glslsandbox uniforms
//uniform float time;
//uniform vec2 resolution;

vec3 outCol = vec3 (.0); 

vec3 turbo(float x) {
  const vec4 kRedVec4 = vec4(0.13572138, 4.61539260, -42.66032258, 132.13108234);
  const vec4 kGreenVec4 = vec4(0.09140261, 2.19418839, 4.84296658, -14.18503333);
  const vec4 kBlueVec4 = vec4(0.10667330, 12.64194608, -60.58204836, 110.36276771);
  const vec2 kRedVec2 = vec2(-152.94239396, 59.28637943);
  const vec2 kGreenVec2 = vec2(4.27729857, 2.82956604);
  const vec2 kBlueVec2 = vec2(-89.90310912, 27.34824973); 
  x = fract(x);
  vec4 v4 = vec4( 1.0, x, x * x, x * x * x);
  vec2 v2 = v4.zw * v4.z;
  return vec3(
    dot(v4, kRedVec4)   + dot(v2, kRedVec2),
    dot(v4, kGreenVec4) + dot(v2, kGreenVec2),
    dot(v4, kBlueVec4)  + dot(v2, kBlueVec2)
  );
}
void yonatansFractal (float t, vec2 FC, vec2 r, inout vec3 o)
{
    float g=0., e, s, k = t*.05;
    for(float i=0.; i < 55.;++i) {
        vec3 p = vec3(g*(FC.xy - .5*r)/r.y + .2,g - 1.);
	p.xz *= mat2(cos(k),sin(k),-sin(k),cos(k));
	p.xy += (vec2(cos(t*.1), sin(t*.1)) + 1.) * vec2(2.5, .25);
        s = 3.;
        for(int i=0; i < 8; ++i ) {
            s *= e = max(1.,(11.-2.*cos(k))/dot(p,p*5.));
            p = vec3(2,4,.1) - abs(abs(p)*e - vec3(4,4,2) );
        }
        g += min(length(p.xz), p.y)/s;
        //o.rg += (s + .9, 11.3, s/5e4);
	o.rgb += turbo(log(pow(s, .175)) + k*.45) * .0165;
    }
}

void main(void)
{
    yonatansFractal(time+50., gl_FragCoord.xy, resolution.xy, outCol);
    gl_FragColor = vec4(outCol + gl_FragCoord.xyz/resolution.xyy*0.12, 1.) * vec4(0.65,1.,1.,1.);
}