uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform float u_Elapsed;

varying vec4 gl_TexCoord[];

void main(void)
{   


   vec4 vTexCoord = gl_TexCoord[0];
    
   highp vec4 wall = texture2D(texture2, vTexCoord.xy);
   highp vec4 back = texture2D(texture0,vTexCoord.xy);
   highp vec4 front = texture2D(texture1, vTexCoord.xy);
   

  
   vec4 girl = (back + front) * gl_Color;											//scattering shadows + model
   girl.rgb = girl.rgb - vec3( min(0.2, abs(0.5-vTexCoord.x)) * 1.0 );				//little x shadow effect
   girl.a = back.a;																	//alpha mask on the model

   // merging the background and the transparent model
   gl_FragColor.r = (girl.r * girl.a) + (wall.r * (1. - girl.a));
   gl_FragColor.g = (girl.g * girl.a) + (wall.g * (1. - girl.a));
   gl_FragColor.b = (girl.b * girl.a) + (wall.b * (1. - girl.a));
   gl_FragColor.a = (girl.a * girl.a) + (wall.a * (1. - girl.a));

}