////////////////////////////// CURTAIN MOTION ///////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.
// Modified for WyldAnimal's Shadow Scenes

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

// -----------------------------------------------------------------------
// Parameters Added by WyldAnimal
// 06-02-2022
//
// Get parameters passed from the scene file
uniform vec3 BkgColor; 
      #ifndef BkgColor
         #define Bkg_Color BkgColor
      #endif
	  
uniform float ITERS; 
      #ifndef ITERS
         #define MAX_ITER ITERS
      #endif

uniform float MSPEED; 
      #ifndef MSPEED
         #define M_SPEED MSPEED
      #endif
// 
// -----------------------------------------------------------------------	  

/////////////////////////////////////////////////////////////////////////////////

// Found this on GLSL sandbox. I really liked it, changed a few things and made it tileable.
// :)
// by David Hoskins.

// -----------------------------------------------------------------------
// Water turbulence effect by joltz0r 2013-07-04, improved 2013-07-07
// -----------------------------------------------------------------------


#define TAU 6.28318530718
//#define MAX_ITER 2 // replaced by same variable passed to shader

void main( void ) 
{
	float time = iGlobalTime * M_SPEED + 23.0;
    // uv should be the 0-1 uv of texture...
	vec2 uv = gl_FragCoord.xy / iResolution.xy;

    vec2 p = mod(uv*TAU, TAU)-250.0;

	vec2 i = vec2(p);
	float c = 1.0;
	float inten = .005;

	for (int n = 0; n < MAX_ITER; n++) 
	{
		float t = time * (1.0 - (3.5 / float(n+1)));
		i = p + vec2(cos(t - i.x) + sin(t + i.y), sin(t - i.y) + cos(t + i.x));
		c += 1.0/length(vec2(p.x / (sin(i.x+t)/inten),p.y / (cos(i.y+t)/inten)));
	}
	c /= float(MAX_ITER);
	c = 1.17-pow(c, 1.4);
	vec3 colour = vec3(pow(abs(c), 8.0));
 //   colour = clamp(colour + vec3(0.85, 0.85, 0.0), 0.0, 1.0);
    colour = clamp(colour + Bkg_Color, 0.0, 1.0);
    

	gl_FragColor = vec4(colour, 1.0);
}