//Shader Inputs
//uniform vec3      iResolution;           // viewport resolution (in pixels)
//uniform float     iGlobalTime;           // shader playback time (in seconds)
//uniform float     iChannelTime[4];       // channel playback time (in seconds)
//uniform vec3      iChannelResolution[4]; // channel resolution (in pixels)
//uniform vec4      iMouse;                // mouse pixel coords. xy: current (if MLB down), zw: click
//uniform samplerXX iChannel0..3;          // input channel. XX = 2D/Cube
//uniform vec4      iDate;                 // (year, month, day, time in seconds)

uniform float u_Elapsed; // same than iGlobalTime
uniform vec2 u_WindowSize; // same than iResolution 
uniform sampler2D texture; // same than iChannel0 


void main()
{
	float time=u_Elapsed;
	float pace=time*.15;
	
	vec2 pos=gl_FragCoord.xy/u_WindowSize.xy;
	float v1=sin(2.*sin(pace*.5)+sin(pos.y*4.)*cos(pace+pos.x*4.)*sin(pos.x+pace*4.0)*5.);
	float v2=sin(2.*pace+pos.y*3.5)*sin(pace*2.)*5.5;
	float v3=sin(2.*sin(pace*2.)+sin(pos.y*20.)*cos(pace-pos.x*20.)*sin(pace)*10.)*sin(pos.y*15.);
	float v4=smoothstep((sin(sin(pos.x+pace*2.5)+sin(pos.y*20.)*cos(pace+pos.x*20.)*20.)*sin(pos.y*5.))*.5,exp(v1)+sin(pace),min(v3,v2)+.5*.25);
	float rand = mod(fract(sin(dot(pos + pace, vec2(23.0,64.0))) * 6553.0), 1.0);

	vec4 res=vec4(max(v1*(v2*v3*sin(pace*2.5)),v4));
	float d = distance(pos, vec2(0.5,0.5));
  	float vig = smoothstep(.67, .1, d);
	gl_FragColor = vig*rand*(res)*vec4(1.75-v2,v4*.75,v2*1.,1.);
}
