#version 130

uniform sampler2D texture0;
vec4 vTexCoord = gl_TexCoord[0];
uniform vec2 textureSize0;
uniform float resmul;
vec2 Offset = vec2(1.0*resmul) / textureSize0;
vec3 LC = vec3(0.2126, 0.7152, 0.0722);


float GetLuma(vec3 rgb) {
    return dot(LC, rgb);
}

void main(void)
{

  vec4 Girl1 = texture2D(texture0, vTexCoord.xy);
  vec4 Girl2 = texture2D(texture0, vTexCoord.xy + Offset * vec2 ( 0.0, 1.0) );
  vec4 Girl3 = texture2D(texture0, vTexCoord.xy + Offset * vec2 ( 1.0, 0.0) );
  vec4 Girl4 = texture2D(texture0, vTexCoord.xy + Offset * vec2 ( 0.0,-1.0) );
  vec4 Girl5 = texture2D(texture0, vTexCoord.xy + Offset * vec2 (-1.0, 0.0) );

  vec3 col;
  col.g = ( (Girl1.b-Girl2.b)-(Girl1.b-Girl4.b) );
  col.r = ( (Girl1.b-Girl3.b)-(Girl1.b-Girl5.b) );


gl_FragColor = vec4( ((col.rg+1.0)*0.5), GetLuma(Girl1.rgb), Girl1.a );


}
