#version 120
//By Z22

uniform sampler2D texture0;//BG
uniform sampler2D texture1;//Girl norm R
uniform sampler2D texture2;//Girl norm G
uniform sampler2D texture3;//Girl norm B
uniform sampler2D texture4;//Tex
uniform vec2 textureSize0;
vec2 vTexCoord = gl_TexCoord[0].xy;
vec3 color;
vec3 color2;
float xmod = distance(vTexCoord.x,0.5);
float ymod = distance(vTexCoord.y,0.5);
vec2 Offset = vec2(1.0) / textureSize0;
///////////////////////////////////////////////////////////////////////////////////////////

void main(void)
{

	vec4 BG  = texture2D ( texture0, vTexCoord.xy ) ;
	vec4 Nr  = texture2D ( texture1, vTexCoord.xy ) ;
	vec4 Ng  = texture2D ( texture2, vTexCoord.xy ) ;
	vec4 Nb  = texture2D ( texture3, vTexCoord.xy ) ;


		vec3 AoI  = vec3( vTexCoord.x, vTexCoord.y, 25.0);// z here effects the detail and ammount of refraction.
		vec3 OutVr = vec3( ((Nr.r*2.0)-1.0), ((Nr.g*2.0)-1.0), 1.0-Nr.b ) ;// alt normal map
		vec3 OutVg = vec3( ((Ng.r*2.0)-1.0), ((Ng.g*2.0)-1.0), 1.0-Ng.b  ) ;
		vec3 OutVb = vec3( ((Nb.r*2.0)-1.0), ((Nb.g*2.0)-1.0), 1.0-Nb.b  ) ;
		vec3 IoR  = vec3(1.52 , 1.5275 , 1.535  );

		// Index of refraction.
		//Ice   R=1.3315 G=1.3345 B=1.3375
		//Glass R=1.52   G=1.5275 B=1.535

		// Refract1

		vec3 refR = (refract(AoI.xyz, OutVr.rgb, IoR.r));
		vec3 refG = (refract(AoI.xyz, OutVg.rgb, IoR.g));
		vec3 refB = (refract(AoI.xyz, OutVb.rgb, IoR.b));

		///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		// Get the pixel colour at the result of refracts.
		color.r = texture2D(texture0, vTexCoord.xy + Offset*vec2( (refR.x)*50.0, refR.y*50.0) ).r;
		color.g = texture2D(texture0, vTexCoord.xy + Offset*vec2( (refG.x)*30.0, refG.y*30.0) ).g;
		color.b = texture2D(texture0, vTexCoord.xy + Offset*vec2( (refB.x)*10.0, refB.y*10.0) ).b;
		///////////////////////////////////////////////////////////////////////////////////////////


gl_FragColor = vec4(color, Nr.a);

}
